/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.util;

import com.wego168.base.model.SensitiveWordNode;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class SensitiveWordUtil {
    public static SensitiveWordNode build(List<String> sensitiveWordList) {
        SensitiveWordNode map = new SensitiveWordNode("0", false, null);
        for (String sensitiveWord : sensitiveWordList) {
            int wordLength = sensitiveWord.length();
            SensitiveWordNode currentNode = null;
            for (int i = 0; i < wordLength; ++i) {
                String character = sensitiveWord.charAt(i) + "";
                boolean end = IntegerUtil.equals((Integer)i, (Integer)(wordLength - 1));
                SensitiveWordNode newNode = new SensitiveWordNode(character, end, null);
                if (currentNode == null) {
                    currentNode = map.get(character);
                    if (map.contains(character)) continue;
                    map.put(character, newNode);
                    currentNode = newNode;
                    continue;
                }
                if (!currentNode.contains(character)) {
                    currentNode.put(character, newNode);
                    currentNode.setEnd(false);
                    currentNode = newNode;
                    continue;
                }
                currentNode = currentNode.get(character);
            }
        }
        return map;
    }

    public static List<String> fullMatch(String text, SensitiveWordNode root) {
        ArrayList<String> matchedSensitiveWords = new ArrayList<String>();
        StringBuffer sensitiveWordBuffer = new StringBuffer();
        SensitiveWordNode current = root;
        for (int i = 0; i < text.length(); ++i) {
            String character = text.charAt(i) + "";
            SensitiveWordNode node = current.get(character);
            if (node != null) {
                sensitiveWordBuffer.append(character);
                current = node;
                if (!node.isEnd()) continue;
                matchedSensitiveWords.add(sensitiveWordBuffer.toString());
                current = root;
                sensitiveWordBuffer = new StringBuffer();
                continue;
            }
            sensitiveWordBuffer = new StringBuffer();
            current = root;
        }
        return Checker.listIsEmpty(matchedSensitiveWords) ? null : matchedSensitiveWords;
    }

    public static String firstMatch(String text, SensitiveWordNode root) {
        String firstSenstiveWord;
        StringBuffer sensitiveWordBuffer = new StringBuffer();
        SensitiveWordNode current = root;
        for (int i = 0; i < text.length(); ++i) {
            String character = text.charAt(i) + "";
            SensitiveWordNode node = current.get(character);
            if (node != null) {
                sensitiveWordBuffer.append(character);
                current = node;
                if (!node.isEnd()) continue;
                break;
            }
            sensitiveWordBuffer = new StringBuffer();
            current = root;
        }
        return StringUtil.isBlank((String)(firstSenstiveWord = sensitiveWordBuffer.toString())) ? null : firstSenstiveWord;
    }

    public static void main(String[] args) {
        ArrayList<String> sensitiveWordList = new ArrayList<String>();
        sensitiveWordList.add("\u4e3e\u62a5");
        sensitiveWordList.add("\u7ea2\u5305");
        sensitiveWordList.add("\u52a0\u6211");
        SensitiveWordNode root = SensitiveWordUtil.build(sensitiveWordList);
        System.out.println(root);
        String text = "\u4e3e\u62a5";
        System.out.println(SensitiveWordUtil.fullMatch(text, root));
        text = "\u7ea2\u5305\u4e3e\u62a5\u52a0\u6211\u7ea2\u5305";
        System.out.println(SensitiveWordUtil.fullMatch(text, root));
        text = "\u4e3e\u62a5\u7ea2\u5305";
        System.out.println(SensitiveWordUtil.fullMatch(text, root));
        text = "\u8fd9\u7ea2\uff0c\u4f60\u8be5\u52a0\u6211\u4e86\u5427";
        System.out.println(SensitiveWordUtil.fullMatch(text, root));
    }
}

