/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.xiumi.controller;

import com.wego168.exception.WegoException;
import com.wego168.util.SimpleJackson;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.util.ParamUtils;
import com.wego168.xiumi.model.ReceiveArticleRequest;
import com.wego168.xiumi.model.XiumiResponse;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/xiumi"})
public class XiumiApiController
extends SimpleController {
    private static final Logger log = LoggerFactory.getLogger(XiumiApiController.class);

    @GetMapping(value={"/getToken"})
    public XiumiResponse getToken(HttpServletRequest request) {
        try {
            String appid = ParamUtils.getString((ServletRequest)request, (String)"appid");
            String timestamp = ParamUtils.getString((ServletRequest)request, (String)"timestamp");
            String nonce = ParamUtils.getString((ServletRequest)request, (String)"nonce");
            String signature = ParamUtils.getString((ServletRequest)request, (String)"signature");
            String access_token = ParamUtils.getString((ServletRequest)request, (String)"access_token");
            String expires_in = ParamUtils.getString((ServletRequest)request, (String)"expires_in");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("appid", appid);
            data.put("timestamp", timestamp);
            data.put("nonce", nonce);
            data.put("signature", signature);
            data.put("access_token", access_token);
            data.put("expires_in", expires_in);
            log.error("\u79c0\u7c73|\u83b7\u53d6token\u7684\u63a5\u53e3getToken -> {}", (Object)SimpleJackson.toJson(data));
            return XiumiResponse.success(data);
        }
        catch (WegoException e) {
            return XiumiResponse.failure((Object)e);
        }
    }

    @PostMapping(value={"/receiveArticle"})
    public XiumiResponse receiveArticle(@Valid @RequestBody ReceiveArticleRequest articleRequest, HttpServletRequest request) {
        try {
            String access_token = ParamUtils.getString((ServletRequest)request, (String)"access_token");
            String timestamp = ParamUtils.getString((ServletRequest)request, (String)"timestamp");
            String uid = ParamUtils.getString((ServletRequest)request, (String)"uid");
            String signature = ParamUtils.getString((ServletRequest)request, (String)"signature");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("access_token", access_token);
            data.put("timestamp", timestamp);
            data.put("uid", uid);
            data.put("signature", signature);
            log.error("\u79c0\u7c73|\u63a5\u6536\u56fe\u6587\u5185\u5bb9\u7684\u63a5\u53e3receiveArticle -> {}", (Object)SimpleJackson.toJson(data));
            if (articleRequest != null) {
                log.error("\u79c0\u7c73|\u63a5\u6536\u56fe\u6587\u5185\u5bb9ReceiveArticleRequest -> {}", (Object)SimpleJackson.toJson((Object)articleRequest));
            }
            return XiumiResponse.success(data);
        }
        catch (WegoException e) {
            return XiumiResponse.failure((Object)e);
        }
    }

    @PostMapping(value={"/receiveImage"})
    public XiumiResponse receiveImage(HttpServletRequest request) {
        try {
            String access_token = ParamUtils.getString((ServletRequest)request, (String)"access_token");
            String timestamp = ParamUtils.getString((ServletRequest)request, (String)"timestamp");
            String uid = ParamUtils.getString((ServletRequest)request, (String)"uid");
            String signature = ParamUtils.getString((ServletRequest)request, (String)"signature");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("access_token", access_token);
            data.put("timestamp", timestamp);
            data.put("uid", uid);
            data.put("signature", signature);
            log.error("\u79c0\u7c73|\u63a5\u6536\u56fe\u7247\u5185\u5bb9\u7684\u63a5\u53e3receiveImage -> {}", (Object)SimpleJackson.toJson(data));
            return XiumiResponse.success(data);
        }
        catch (WegoException e) {
            return XiumiResponse.failure((Object)e);
        }
    }

    @GetMapping(value={"/gotoAfterEdit"})
    public XiumiResponse gotoAfterEdit(HttpServletRequest request) {
        try {
            String access_token = ParamUtils.getString((ServletRequest)request, (String)"access_token");
            String timestamp = ParamUtils.getString((ServletRequest)request, (String)"timestamp");
            String uid = ParamUtils.getString((ServletRequest)request, (String)"uid");
            String signature = ParamUtils.getString((ServletRequest)request, (String)"signature");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("access_token", access_token);
            data.put("timestamp", timestamp);
            data.put("uid", uid);
            data.put("signature", signature);
            log.error("\u79c0\u7c73|\u7f16\u8f91\u5b8c\u6210\u540e\u8df3\u8f6c\u7684\u63a5\u53e3gotoAfterEdit -> {}", (Object)SimpleJackson.toJson(data));
            return XiumiResponse.success(data);
        }
        catch (WegoException e) {
            return XiumiResponse.failure((Object)e);
        }
    }
}

