/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.logconfig.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;

public class LevelRangeFilter<E>
extends Filter<E> {
    private boolean acceptOnMatch = false;
    private Level levelMin;
    private Level levelMax;

    public void setLevelMax(Level levelMax) {
        this.levelMax = levelMax;
    }

    public void setLevelMin(Level levelMin) {
        this.levelMin = levelMin;
    }

    public void setAcceptOnMatch(boolean acceptOnMatch) {
        this.acceptOnMatch = acceptOnMatch;
    }

    public FilterReply decide(E eventObject) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        LoggingEvent event = (LoggingEvent)eventObject;
        if (this.levelMin != null && !event.getLevel().isGreaterOrEqual(this.levelMin)) {
            return FilterReply.DENY;
        }
        if (this.levelMax != null && event.getLevel().toInt() > this.levelMax.toInt()) {
            return FilterReply.DENY;
        }
        if (this.acceptOnMatch) {
            return FilterReply.ACCEPT;
        }
        return FilterReply.NEUTRAL;
    }

    public void start() {
        if (this.levelMin != null || this.levelMax != null) {
            super.start();
        }
    }
}

