/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader;

import com.taobao.pandora.boot.loader.jmx.mbean.ClassInfo;
import com.taobao.pandora.boot.loader.util.ClassLoaderUtils;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseLaunchURLClassLoader
extends URLClassLoader {
    protected Map<String, Class<?>> classCache;
    private static boolean enableClassJarInfo;
    private AtomicBoolean INIT_CLASS_INFO = new AtomicBoolean(false);
    private Set<ClassLoader> pandoraClassLoaders = new HashSet<ClassLoader>(64);
    private Set<String> pandoraJars = Collections.emptySet();
    private Set<String> webappJars = new HashSet<String>(256);
    private Set<String> usedJars = new HashSet<String>();

    protected BaseLaunchURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public void collectStaticClassInfo() {
        if (!enableClassJarInfo) {
            return;
        }
        if (this.INIT_CLASS_INFO.compareAndSet(false, true)) {
            try {
                this.collectClassInfoFromWebapp();
                ClassInfo.registerMBean(this);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected void recordClass(Class<?> clazz) {
        if (!enableClassJarInfo) {
            return;
        }
        if (clazz != null) {
            try {
                URL url = ClassLoaderUtils.locateURL(clazz);
                if (url != null && url.getFile().contains(".jar")) {
                    this.usedJars.add(url.getFile());
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    private void collectClassInfoFromWebapp() {
        File jreDir;
        File javaHomeDir;
        if (!enableClassJarInfo) {
            return;
        }
        URL[] urls = this.getURLs();
        if (urls == null) {
            return;
        }
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            javaHome = System.getenv("JAVA_HOME");
        }
        if (javaHome != null && javaHome.endsWith("jre") && (javaHomeDir = (jreDir = new File(javaHome)).getParentFile()) != null && javaHomeDir.getParentFile() != null) {
            javaHome = javaHomeDir.getAbsolutePath();
        }
        for (URL url : urls) {
            if (javaHome != null && url.getFile().startsWith(javaHome) || !url.getFile().contains(".jar")) continue;
            this.webappJars.add(url.getFile());
        }
    }

    public Set<ClassLoader> getPandoraClassLoaders() {
        return this.pandoraClassLoaders;
    }

    public Set<String> getPandoraJars() {
        return this.pandoraJars;
    }

    public Set<String> getWebappJars() {
        return this.webappJars;
    }

    public Set<String> getUsedJars() {
        return this.usedJars;
    }

    static void reset() {
        try {
            enableClassJarInfo = Boolean.valueOf(System.getProperty("pandora.boot.statistic.jars.enable", "true"));
        }
        catch (Exception e) {
            enableClassJarInfo = false;
        }
    }

    static {
        BaseLaunchURLClassLoader.reset();
    }
}

