/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.iface.customer;

import com.plat.csp.iface.common.BaseController;
import com.plat.csp.service.customer.CustomerService;
import com.plat.csp.service.enterprise.EnterpriseService;
import com.plat.framework.common.Result;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/custom"})
public class CustomerController
extends BaseController {
    @Autowired
    EnterpriseService enterpriseService;
    @Autowired
    CustomerService customerService;

    @RequestMapping(value={"addEnterprise"})
    public Result addEnterprise() {
        Map param = this.getWrapParam().getParamMap();
        Map result = this.enterpriseService.createEnterprise(param);
        return this.getResult(result, "0000");
    }

    @RequestMapping(value={"addCustomer"})
    public Result addCustomer() {
        Map param = this.getWrapParam().getParamMap();
        Long customerId = this.customerService.createCustomer(param);
        param.put("id", customerId);
        return this.getResult(param, "0000");
    }

    @RequestMapping(value={"updateCustomer"})
    public Result updateCustomer() {
        Map param = this.getWrapParam().getParamMap();
        this.customerService.updateCustomer(param);
        return this.getResult(param, "0000");
    }

    @RequestMapping(value={"addCP"})
    public Result saveCustomerProduct() {
        String enterpriseId = (String)this.getWrapParam().getParam("enterpriseId");
        String customerId = (String)this.getWrapParam().getParam("customerId");
        List productIds = (List)this.getWrapParam().getParam("productIds");
        this.customerService.saveCustomerAndProduct(enterpriseId, customerId, productIds);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"addPC"})
    public Result saveProductCustomer() {
        String enterpriseId = (String)this.getWrapParam().getParam("enterpriseId");
        String productId = (String)this.getWrapParam().getParam("productId");
        List customerIds = (List)this.getWrapParam().getParam("customerIds");
        this.customerService.saveProductAndCustomer(enterpriseId, productId, customerIds);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"deleteCP"})
    public Result deleteCustomerProduct() {
        String enterpriseId = (String)this.getWrapParam().getParam("enterpriseId");
        String customerId = (String)this.getWrapParam().getParam("customerId");
        List productIds = (List)this.getWrapParam().getParam("productIds");
        this.customerService.deleteCustomerAndProduct(enterpriseId, customerId, productIds);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"deletePC"})
    public Result deleteProductCustomer() {
        String enterpriseId = (String)this.getWrapParam().getParam("enterpriseId");
        String productId = (String)this.getWrapParam().getParam("productId");
        List customerIds = (List)this.getWrapParam().getParam("customerIds");
        this.customerService.deleteProductAndCustomer(enterpriseId, productId, customerIds);
        return this.getSuccessResult(null);
    }
}

