/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.iface.product;

import com.plat.csp.iface.common.BaseController;
import com.plat.csp.service.common.BaseService;
import com.plat.csp.service.product.ProductService;
import com.plat.framework.common.Result;
import com.plat.framework.common.WrapParam;
import com.plat.framework.exception.AppException;
import com.tcbj.util.Beans;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/product"})
public class ProductController
extends BaseController {
    @Autowired
    BaseService baseService;
    @Autowired
    ProductService productService;

    private void validateProductTypeIdList(WrapParam param) {
        if (Beans.isEmpty((Object)param.getParam("productTypeIdList"))) {
            throw new AppException("4000");
        }
    }

    private void validateProductTypeExist(String orgId, String typeId) {
    }

    private void validateParentProductTypeExist(String orgId, String typeId) {
        if (Beans.isNotEmpty((Object)typeId)) {
            this.validateProductTypeExist(orgId, typeId);
        }
    }

    @RequestMapping(value={"addProduct"})
    public Result addProduct() {
        WrapParam param = this.getWrapParam();
        this.validateProductTypeIdList(param);
        String productId = this.productService.addProduct(param.getParamMap());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("productId", productId);
        return this.getSuccessResult(result);
    }

    @RequestMapping(value={"editProduct"})
    public Result editProduct() {
        WrapParam param = this.getWrapParam();
        this.validateProductTypeIdList(param);
        String productId = this.productService.addProduct(param.getParamMap());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("productId", productId);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"addProductType"})
    public Result addProductType() {
        WrapParam param = this.getWrapParam();
        String parentTypeId = (String)param.getParam("parentTypeId");
        String orgId = this.getBrandId();
        this.validateParentProductTypeExist(orgId, parentTypeId);
        long id = this.baseService.saveMap("ProductType", param.getParamMap());
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("productTypeId", id);
        return this.getSuccessResult(result);
    }

    @RequestMapping(value={"editProductType"})
    public Result editProductType() {
        WrapParam param = this.getWrapParam();
        String parentTypeId = (String)param.getParam("parentTypeId");
        String orgId = this.getBrandId();
        this.validateParentProductTypeExist(orgId, parentTypeId);
        this.baseService.updateMap("ProductType", param.getParamMap());
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"delProductType"})
    public Result delProductType() {
        WrapParam param = this.getWrapParam();
        this.validateProductTypeIdList(param);
        String orgId = this.getBrandId();
        List typeIds = (List)param.getParam("productTypeIdList");
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"queryProductType"})
    public Result queryProductType() {
        String orgId = this.getBrandId();
        HashMap result = new HashMap();
        return this.getSuccessResult(result);
    }
}

