/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.iface.sys;

import com.plat.csp.dao.util.Page;
import com.plat.csp.iface.common.BaseController;
import com.plat.csp.service.common.BaseService;
import com.plat.framework.common.Result;
import com.plat.framework.common.WrapParam;
import com.plat.framework.exception.AppException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys"})
public class SysController
extends BaseController {
    @Autowired
    BaseService baseService;
    private int pageNo = 0;
    private int pageSize = 10;
    private final String ADD = "add";
    private final String UPDATE = "update";
    private final String DEL = "delete";
    private final String QUERY = "query";
    private final String BATCH_ADD = "badd";
    private final String BATCH_UPDATE = "bupdate";

    @RequestMapping(value={"{businessType}/{oper}"})
    public Result commonOperate(@PathVariable String businessType, @PathVariable String oper) {
        WrapParam param = this.getWrapParam();
        if ("add".equals(oper)) {
            return this.add(businessType, param);
        }
        if ("update".equals(oper)) {
            return this.update(businessType, param);
        }
        if ("delete".equals(oper)) {
            return this.delete(businessType, param);
        }
        if ("query".equals(oper)) {
            return this.query(businessType, param);
        }
        if ("badd".equals(oper)) {
            return this.batchAdd(businessType, param);
        }
        if ("bupdate".equals(oper)) {
            return this.batchUpdate(businessType, param);
        }
        throw new AppException("0002");
    }

    @RequestMapping(value={"page/{businessType}"})
    public Result commonQueryPage(@PathVariable String businessType) {
        WrapParam param = this.getWrapParam();
        Page p = this.baseService.commonQueryPage(businessType, param.getParamMap());
        return this.getResult(p, "0000");
    }

    @RequestMapping(value={"list/{businessType}"})
    public Result commonQueryList(@PathVariable String businessType) {
        WrapParam param = this.getWrapParam();
        List p = this.baseService.commonQueryList(businessType, param.getParamMap());
        return this.getResult(p, "0000");
    }

    @RequestMapping(value={"bda/{businessType}"})
    public Result bda(@PathVariable String businessType) {
        WrapParam param = this.getWrapParam();
        this.baseService.batchDeleteAndSave(businessType, param.getParamMap());
        return this.getResult(null, "0000");
    }

    public Result batchAdd(String businessType, WrapParam param) {
        List data = (List)param.getParam("data");
        this.baseService.batchInsertMap(businessType, data);
        return this.getResult(null, "0000");
    }

    public Result batchUpdate(String businessType, WrapParam param) {
        List data = (List)param.getParam("data");
        this.baseService.batchUpdateMap(businessType, data);
        return this.getResult(null, "0000");
    }

    private Result add(String businessType, WrapParam param) {
        Map map = param.getParamMap();
        long id = this.baseService.saveMap(businessType, map);
        map.put("id", id);
        return this.getResult(map, "0000");
    }

    private Result update(String businessType, WrapParam param) {
        Map map = param.getParamMap();
        this.baseService.updateMap(businessType, map);
        return this.getResult(map, "0000");
    }

    private Result delete(String businessType, WrapParam param) {
        this.baseService.commonDelete(businessType, param.getParamMap());
        return this.getResult(null, "0000");
    }

    private Result query(String businessType, WrapParam param) {
        Map data = this.baseService.commonQuery(businessType, (String)param.getParam("id"), (String)param.getParam("brandId"));
        return this.getResult(data, "0000");
    }

    @RequestMapping(value={"saveSys"})
    public Result saveSys() {
        WrapParam param = this.getWrapParam();
        Map map = param.getParamMap();
        long id = this.baseService.saveMap(map.get("bussiness_type").toString(), map);
        map.put("id", id);
        return this.getResult(map, "1000");
    }

    @RequestMapping(value={"updateSys"})
    public Result updateSys() {
        WrapParam param = this.getWrapParam();
        Map map = param.getParamMap();
        this.baseService.updateMap(map.get("bussiness_type").toString(), map);
        return this.getResult(map, "1001");
    }
}

