/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.service.enterprise.impl;

import com.plat.csp.dao.common.BaseDao;
import com.plat.csp.service.common.BaseServiceImpl;
import com.plat.csp.service.enterprise.EnterpriseService;
import com.tcbj.util.Beans;
import com.tcbj.util.MD5;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="enterpriseService")
public class EnterpriseServiceImpl
extends BaseServiceImpl
implements EnterpriseService {
    @Autowired
    BaseDao baseDao;

    @Override
    public Map<String, Object> createEnterprise(Map<String, Object> param) {
        param.put("enterpriseLevel", "1");
        param.put("createTime", new Date());
        long enterpriseId = this.baseDao.saveMap("enterprise", param);
        long brandId = this.initBrand(enterpriseId, param.get("enterpriseName").toString());
        String roleCode = this.initRole(brandId);
        this.initRoleFuction(brandId, roleCode, "1");
        Map<String, Object> user = this.addUser(brandId, param);
        this.initRoleUser(brandId, user.get("userCode").toString(), roleCode);
        return user;
    }

    private long initBrand(long enterpriseId, String enterpriseName) {
        HashMap<String, Object> brand = new HashMap<String, Object>();
        brand.put("brandName", enterpriseName);
        brand.put("createTime", new Date());
        brand.put("enterpriseId", enterpriseId);
        long id = this.baseDao.saveMap("brand", brand);
        return id;
    }

    private String initRole(long brandId) {
        HashMap<String, Object> role = new HashMap<String, Object>();
        role.put("roleCode", "admin");
        role.put("roleName", "\u8d85\u7ea7\u7ba1\u7406\u5458");
        role.put("createTime", new Date());
        role.put("brandId", brandId);
        role.put("status", "1");
        this.baseDao.saveMap("role", role);
        return "admin";
    }

    private Map<String, Object> addUser(long brandId, Map<String, Object> param) {
        HashMap<String, Object> user = new HashMap<String, Object>();
        user.put("userName", param.get("userName"));
        user.put("userCode", param.get("userCode"));
        user.put("password", MD5.GetMD5Code((String)param.get("password").toString()));
        user.put("brandId", brandId);
        this.baseDao.saveMap("user", user);
        return user;
    }

    private void initRoleFuction(long brandId, String roleCode, String level) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("level", level);
        String sql = this.baseDao.getTemplateSql("queryLevelFunction", param);
        List functions = this.baseDao.queryToList(sql);
        if (Beans.isNotEmpty((Object)functions)) {
            ArrayList<Map> rolefuns = new ArrayList<Map>();
            for (Map m : functions) {
                Object code = m.get("functionCode");
                m.clear();
                m.put("roleCode", roleCode);
                m.put("functionCode", code);
                m.put("createDate", new Date());
                m.put("brandId", brandId);
                rolefuns.add(m);
            }
            this.baseDao.batchInsertMap("roleFunction", rolefuns);
        }
    }

    private void initRoleUser(long brandId, String userCode, String roleCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roleCode", roleCode);
        map.put("userCode", userCode);
        map.put("createDate", new Date());
        map.put("brandId", brandId);
        this.baseDao.saveMap("userRole", map);
    }
}

