/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.service.power.impl;

import com.plat.csp.dao.common.BaseDao;
import com.plat.csp.domain.entity.power.Function;
import com.plat.csp.service.common.BaseServiceImpl;
import com.plat.csp.service.power.PowerService;
import com.tcbj.util.Beans;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="powerService")
public class PowerServiceImpl
extends BaseServiceImpl
implements PowerService {
    Comparator<Map<String, Object>> funCom = (m1, m2) -> {
        Integer sort1 = Integer.valueOf(m1.get("sort").toString());
        Integer sort2 = Integer.valueOf(m2.get("sort").toString());
        if (sort1 >= sort2) {
            return -1;
        }
        return 1;
    };

    @Override
    public void refreshFunctions(List<Function> funtions) {
        if (Beans.isNotEmpty(funtions)) {
            this.baseDao.deleteAllEntity(Function.class);
            this.baseDao.batchSaveEntity(funtions);
        }
    }

    @Override
    public Map<String, Object> getMenuAndFunction(String userCode) {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        List<Map<String, Object>> menu = this.getMenu(userCode);
        List<Map<String, Object>> allFuns = this.getAllFunctions(userCode);
        retVal.put("menuTree", menu);
        retVal.put("allFuns", allFuns);
        return retVal;
    }

    private void sort(List<Map<String, Object>> result) {
        result.sort(this.funCom);
        result.forEach(m -> {
            if (Beans.isNotEmpty(m.get("children"))) {
                List children = (List)m.get("children");
                this.sort(children);
            }
        });
    }

    private List<Map<String, Object>> getMenu(String userCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userCode", userCode);
        param.put("fType", "menu");
        String sqlVal = this.getInnerTemplateSql("queryUserFunction", param);
        List menus = this.baseDao.queryToList(sqlVal);
        ArrayList<Map<String, Object>> menu = new ArrayList<Map<String, Object>>();
        HashMap menuMap = new HashMap();
        menus.forEach(m -> menuMap.put(m.get("functionCode").toString(), m));
        menus.forEach(m -> {
            if (Beans.isEmpty(m.get("parentCode"))) {
                menu.add((Map<String, Object>)m);
            } else {
                String parentCode = m.get("parentCode").toString();
                Map father = (Map)menuMap.get(parentCode);
                List<Map> children = Beans.isEmpty(father.get("children")) ? new ArrayList() : (List)father.get("children");
                children.add((Map)m);
                father.put("children", children);
            }
        });
        this.sort(menu);
        return menu;
    }

    private List<Map<String, Object>> getAllFunctions(String userCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userCode", userCode);
        String sqlVal = this.getInnerTemplateSql("queryUserFunction", param);
        List funs = this.baseDao.queryToList(sqlVal);
        return funs;
    }

    @Override
    @Autowired
    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public boolean checkPower(String userCode, String functionCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userCode", userCode);
        param.put("functionCode", functionCode);
        String sql = this.getInnerTemplateSql("checkPower", param);
        List result = this.baseDao.queryToList(sql);
        return Beans.isNotEmpty((Object)result);
    }
}

