/*
 * Decompiled with CFR 0.152.
 */
package com.plat.framework.exception;

import com.tcbj.common.config.ConfigFactory;
import com.tcbj.util.Beans;
import java.text.MessageFormat;

public class AppException
extends RuntimeException {
    private static final long serialVersionUID = 397623074911083068L;
    private String errorCode;
    private String errorMsg;

    public AppException(Throwable e) {
        super(e);
        this.errorCode = "9999";
    }

    public AppException(String errorCode) {
        this.errorCode = errorCode;
        this.errorMsg = ConfigFactory.get().get(errorCode);
    }

    public AppException(String errorCode, String errorMsg) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public AppException(String errorCode, Object[] param) {
        this.errorCode = errorCode;
        if (Beans.isNotEmpty((Object)param)) {
            String msg = ConfigFactory.get().get(errorCode);
            this.errorMsg = MessageFormat.format(msg, param);
        }
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        if (Beans.isNotEmpty((Object)this.errorMsg)) {
            return this.errorMsg;
        }
        if (Beans.isNotEmpty((Object)this.getErrorCode())) {
            return ConfigFactory.get().get(this.errorCode);
        }
        return null;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}

