/*
 * Decompiled with CFR 0.152.
 */
package com.plat.redis.io;

import com.plat.redis.exception.ConfigNotFoundException;
import com.plat.redis.exception.ParseConfigFileException;
import com.plat.redis.io.RedisClusterConfig;
import com.plat.redis.io.RedisSentinelConfig;
import com.plat.redis.io.RedisSingleConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ConfigLoader {
    private String CONFIG_FILE_PATH = "classpath*:redis_config.properties";
    private static String SINGLE = "single";
    private static String CLUSTER = "cluster";
    private static String SENTINEL = "sentinel";

    private Resource loadResource() {
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resourceResolver.getResources(this.CONFIG_FILE_PATH);
            if (resources == null || resources.length == 0) {
                throw new ConfigNotFoundException("config file not found:" + this.CONFIG_FILE_PATH);
            }
            Resource resource = resources[0];
            return resource;
        }
        catch (IOException e) {
            throw new ConfigNotFoundException("config file not found:" + this.CONFIG_FILE_PATH);
        }
    }

    public Map<String, GenericObjectPoolConfig> getConfig() {
        HashMap<String, GenericObjectPoolConfig> config = new HashMap<String, GenericObjectPoolConfig>();
        Properties p = new Properties();
        Resource r = this.loadResource();
        InputStream is = null;
        try {
            is = r.getInputStream();
            p.load(is);
            for (Object k : p.keySet()) {
                String node;
                String key = k.toString();
                String[] str = key.split("\\.");
                String appId = str[1];
                if (config.containsKey(appId)) continue;
                String mode = str[0];
                GenericObjectPoolConfig c = null;
                if (SINGLE.equals(mode)) {
                    node = p.getProperty("single." + appId + ".node");
                    c = new RedisSingleConfig(node);
                } else if (CLUSTER.equals(mode)) {
                    node = p.getProperty("cluster." + appId + ".nodes");
                    c = new RedisClusterConfig(node);
                } else if (SENTINEL.equals(mode)) {
                    String sentinels = p.getProperty("sentinel." + appId + ".sentinels");
                    String masterName = p.getProperty("sentinel." + appId + ".master");
                    c = new RedisSentinelConfig(sentinels, masterName);
                } else {
                    throw new ParseConfigFileException("parsing config file error");
                }
                int max_idle = p.get(mode + "." + appId + ".max_idle") == null || "".equals(p.get(mode + "." + appId + ".max_idle")) ? 5 : Integer.valueOf(p.get(mode + "." + appId + ".max_idle").toString());
                int max_active = p.get(mode + "." + appId + ".max_active") == null || "".equals(p.get(mode + "." + appId + ".max_active")) ? 500 : Integer.valueOf(p.get(mode + "." + appId + ".max_active").toString());
                long max_wait = p.get(mode + "." + appId + ".max_wait") == null || "".equals(p.get(mode + "." + appId + ".max_wait")) ? 100000L : (long)Integer.valueOf(p.get(mode + "." + appId + ".max_wait").toString()).intValue();
                c.setMaxIdle(max_idle);
                c.setMaxTotal(max_active);
                c.setMaxWaitMillis(max_wait);
                config.put(appId, c);
            }
            HashMap<String, GenericObjectPoolConfig> hashMap = config;
            return hashMap;
        }
        catch (IOException e) {
            throw new ParseConfigFileException("parsing config file error");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

