/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.excel;

import com.tcbj.framework.excel.ExcelExportHandler;
import com.tcbj.framework.excel.ExcelVersion;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelCreator<T> {
    private ExcelVersion version;
    private List<T> data;

    public ExcelCreator(ExcelVersion version, List<T> data) {
        this.version = version;
        this.data = data;
    }

    public Workbook create(String sheetName, String[] titles, String[] pop, ExcelExportHandler<T> handler) throws Exception {
        int i;
        Workbook workbook = this.getWorkbook(this.version);
        Sheet sheet = workbook.createSheet(sheetName);
        Row row = sheet.createRow(0);
        for (i = 0; i < titles.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(titles[i]);
        }
        for (i = 0; i < this.data.size(); ++i) {
            boolean isMap;
            row = sheet.createRow(i + 1);
            T obj = this.data.get(i);
            if (handler != null) {
                handler.invoke(obj);
            }
            boolean bl = isMap = Map.class.isAssignableFrom(obj.getClass());
            if (isMap) {
                Map map = (Map)obj;
                List<String> prop = Arrays.asList(pop);
                for (int j = 0; j < prop.size(); ++j) {
                    Cell cell = row.createCell(j);
                    Object result = map.get(prop.get(j));
                    cell.setCellValue(result == null ? "" : result.toString());
                }
                continue;
            }
            List<String> prop = Arrays.asList(pop);
            for (int j = 0; j < prop.size(); ++j) {
                Cell cell = row.createCell(j);
                Object result = ExcelCreator.getPropValue(obj.getClass(), obj, prop.get(j));
                cell.setCellValue(result == null ? "" : result.toString());
            }
        }
        return workbook;
    }

    private Workbook getWorkbook(ExcelVersion version) throws Exception {
        HSSFWorkbook wb = null;
        if (ExcelVersion.EXCEL_2003 == version) {
            wb = new HSSFWorkbook();
        } else if (ExcelVersion.EXCEL_2007 == version) {
            wb = new XSSFWorkbook();
        } else {
            throw new RuntimeException("Unsuport version of the excel type");
        }
        return wb;
    }

    public static Object getPropValue(Class clazz, Object obj, String prop) throws Exception {
        String getName = "get" + prop.substring(0, 1).toUpperCase(Locale.ENGLISH) + prop.substring(1);
        Method rM = clazz.getMethod(getName, new Class[0]);
        return rM.invoke(obj, new Object[0]);
    }
}

