/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.auth;

import com.tcbj.framework.dto.inout.BaseResponse;
import com.tcbj.framework.errorcode.common.ResponseCode;
import java.util.List;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.resourceloading.PlatformResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ValidExceptionHandler {
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public BaseResponse<?> handleParam(MethodArgumentNotValidException e) {
        BindingResult br = e.getBindingResult();
        List allErrors = br.getAllErrors();
        StringBuilder sb = new StringBuilder();
        for (ObjectError allError : allErrors) {
            if (StringUtils.isEmpty((Object)sb.toString())) {
                sb.append(allError.getDefaultMessage());
                continue;
            }
            sb.append(";").append(allError.getDefaultMessage());
        }
        return new BaseResponse(ResponseCode.BAD_REQUEST.intValue(), sb.toString());
    }

    @Bean
    public Validator getValidator() {
        Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ResourceBundleMessageInterpolator((ResourceBundleLocator)new PlatformResourceBundleLocator("i18n/messages"))).buildValidatorFactory().getValidator();
        return validator;
    }
}

