/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.auth.service;

import com.tcbj.framework.auth.inout.UserInfoDto;
import com.tcbj.framework.common.util.DateUtil;
import com.tcbj.framework.jwt.common.JWTUtil;
import com.tcbj.framework.jwt.inout.UserInfo;
import com.tcbj.framework.jwt.service.JWTCallBackService;
import io.jsonwebtoken.Claims;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JWTCallBackServiceImpl
implements JWTCallBackService {
    public UserInfo parseUser(Claims claims) {
        UserInfoDto userInfoDto = new UserInfoDto();
        userInfoDto.setUserId(claims.get((Object)"id").toString());
        if (claims.get((Object)"tenant") != null) {
            userInfoDto.setTenantMap((Map)claims.get((Object)"tenant"));
        }
        if (claims.get((Object)"userName") != null) {
            userInfoDto.setUserName(claims.get((Object)"userName").toString());
        }
        if (claims.get((Object)"phone") != null) {
            userInfoDto.setPhone(claims.get((Object)"phone").toString());
        }
        if (claims.get((Object)"userType") != null) {
            userInfoDto.setUserType((Integer)claims.get((Object)"userType"));
        }
        if (claims.get((Object)"userReal") != null) {
            userInfoDto.setUserRealMap((Map)claims.get((Object)"userReal"));
        }
        if (claims.get((Object)"loginName") != null) {
            userInfoDto.setLoginName(claims.get((Object)"loginName").toString());
        }
        JWTUtil.getLocalUser().set(userInfoDto);
        return userInfoDto;
    }

    public Map<String, Object> buildJWTMap(UserInfo userInfo) {
        HashMap<String, Object> jwtMap = new HashMap<String, Object>();
        jwtMap.put("id", userInfo.getUserId());
        jwtMap.put("loginName", userInfo.getLoginName());
        jwtMap.put("userName", userInfo.getUserName());
        jwtMap.put("phone", userInfo.getPhone());
        jwtMap.put("userType", userInfo.getUserType());
        jwtMap.put("userReal", userInfo.getUserRealMap());
        jwtMap.put("tenant", userInfo.getTenantMap());
        jwtMap.put("expirationTime", DateUtil.addHour((Date)new Date(), (int)8));
        return jwtMap;
    }
}

