/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.marketing.openapi.backlog.server.common;

import com.tcbj.jdbc.core.Repository;
import com.tcbj.jdbc.factory.RepositoryFactory;
import com.tcbj.jdbc.io.RepositoryConfiguration;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class DataBaseConfig {
    @Autowired
    private Environment env;

    public HikariDataSource dataSource1() throws Exception {
        HikariDataSource ds = new HikariDataSource();
        ds.setDriverClassName(this.env.getProperty("driverclass1"));
        ds.setJdbcUrl(this.env.getProperty("jdbcurl1"));
        ds.setUsername(this.env.getProperty("user1"));
        ds.setPassword(this.env.getProperty("password1"));
        ds.setMaximumPoolSize(Integer.valueOf(this.env.getProperty("hikari.pool.maximumPoolSize1")).intValue());
        return ds;
    }

    public HikariDataSource dataSource2() throws Exception {
        HikariDataSource ds = new HikariDataSource();
        ds.setDriverClassName(this.env.getProperty("driverclass2"));
        ds.setJdbcUrl(this.env.getProperty("jdbcurl2"));
        ds.setUsername(this.env.getProperty("user2"));
        ds.setPassword(this.env.getProperty("password2"));
        ds.setMaximumPoolSize(Integer.valueOf(this.env.getProperty("hikari.pool.maximumPoolSize2")).intValue());
        return ds;
    }

    @Bean(name={"repository1"})
    public Repository repository1() throws Exception {
        RepositoryConfiguration c = new RepositoryConfiguration();
        c.setDatasource((DataSource)this.dataSource1());
        c.setDialect("com.tcbj.jdbc.dialect.OracleDialectHandler");
        c.setPackagesToScan("com.tcbj.marketing.openapi.basesubject.server.entity");
        Repository r = RepositoryFactory.createRepository((RepositoryConfiguration)c);
        return r;
    }

    @Bean(name={"repository2"})
    public Repository repository2() throws Exception {
        RepositoryConfiguration c = new RepositoryConfiguration();
        c.setDatasource((DataSource)this.dataSource2());
        c.setDialect("com.tcbj.jdbc.dialect.OracleDialectHandler");
        c.setPackagesToScan("com.tcbj.marketing.openapi.basesubject.server.entity");
        Repository r = RepositoryFactory.createRepository((RepositoryConfiguration)c);
        return r;
    }
}

