/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.msyxy.attachment.controller;

import com.tcbj.msyxy.attachment.fastdfs.FastDFSClient;
import com.tcbj.msyxy.attachment.fastdfs.FastDFSException;
import com.tcbj.msyxy.attachment.fastdfs.FileCheck;
import com.tcbj.msyxy.attachment.fastdfs.FileResponseData;
import com.tcbj.msyxy.common.exception.Thrower;
import com.tcbj.msyxy.common.util.ResultUtil;
import com.tcbj.msyxy.common.vo.Result;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/fastdfs"})
public class FastdfsController {
    private FastDFSClient fastDFSClient = new FastDFSClient();
    @Value(value="${file_server_addr}")
    private String fileServerAddr;
    @Value(value="${fastdfs.http_secret_key}")
    private String fastDFSHttpSecretKey;

    @RequestMapping(value={"/test"})
    @ResponseBody
    public FileResponseData test() {
        return new FileResponseData();
    }

    @RequestMapping(value={"/upload/file/sample"})
    @ResponseBody
    public Result<FileResponseData> uploadFileSample(MultipartFile file, HttpServletRequest request) {
        return this.uploadSample(file, request);
    }

    @RequestMapping(value={"/upload/image/sample"})
    @ResponseBody
    public Result<FileResponseData> uploadImageSample(@RequestParam MultipartFile file, HttpServletRequest request) {
        if (!FileCheck.checkImage(file.getOriginalFilename())) {
            Thrower.throwAppException((String)"error.file.type.image");
        }
        return this.uploadSample(file, request);
    }

    @RequestMapping(value={"/upload/doc/sample"})
    @ResponseBody
    public Result<FileResponseData> uploadDocSample(@RequestParam MultipartFile file, HttpServletRequest request) {
        if (!FileCheck.checkDoc(file.getOriginalFilename())) {
            Thrower.throwAppException((String)"error.file.type.doc");
        }
        return this.uploadSample(file, request);
    }

    @RequestMapping(value={"/download/file"})
    public void downloadFile(String filePath, HttpServletResponse response) throws FastDFSException {
        try {
            this.fastDFSClient.downloadFile(filePath, response);
        }
        catch (FastDFSException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @RequestMapping(value={"/download/image"})
    public void downloadImage(String filePath, HttpServletResponse response) throws FastDFSException {
        try {
            this.fastDFSClient.downloadFile(filePath, (OutputStream)response.getOutputStream());
        }
        catch (FastDFSException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/delete/file"})
    public FileResponseData deleteFile(String filePath, Locale locale) {
        FileResponseData responseData = new FileResponseData();
        try {
            this.fastDFSClient.deleteFile(filePath);
        }
        catch (FastDFSException e) {
            e.printStackTrace();
            Thrower.throwAppException((String)"error.system.error");
        }
        return responseData;
    }

    @RequestMapping(value={"/get/token"})
    @ResponseBody
    public Result<FileResponseData> getToken(String filePath) {
        FileResponseData responseData = new FileResponseData();
        String token = FastDFSClient.getToken(filePath, this.fastDFSHttpSecretKey);
        responseData.setToken(token);
        responseData.setHttpUrl(this.fileServerAddr + "/" + filePath + "?" + token);
        return ResultUtil.getSucessResult((Object)responseData);
    }

    public Result<FileResponseData> uploadSample(MultipartFile file, HttpServletRequest request) {
        FileResponseData responseData = new FileResponseData();
        try {
            String filepath = this.fastDFSClient.uploadFileWithMultipart(file);
            responseData.setFileName(file.getOriginalFilename());
            responseData.setFilePath(filepath);
            responseData.setFileType(FastDFSClient.getFilenameSuffix(file.getOriginalFilename()));
            String token = FastDFSClient.getToken(filepath, this.fastDFSHttpSecretKey);
            responseData.setToken(token);
            responseData.setHttpUrl("http://" + this.fileServerAddr + "/" + filepath);
        }
        catch (FastDFSException e) {
            e.printStackTrace();
            Thrower.throwAppException((String)"error.system.error");
        }
        return ResultUtil.getSucessResult((Object)responseData);
    }
}

