/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.msyxy.attachment.fastdfs;

import com.tcbj.msyxy.attachment.fastdfs.ErrorCode;
import com.tcbj.msyxy.attachment.fastdfs.FastDFSException;
import com.tcbj.msyxy.attachment.fastdfs.TrackerServerPool;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.codec.binary.Base64;
import org.csource.common.MyException;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.FileInfo;
import org.csource.fastdfs.ProtoCommon;
import org.csource.fastdfs.StorageClient1;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class FastDFSClient {
    public static final String SEPARATOR = "/";
    public static final String POINT = ".";
    public static final Map<String, String> EXT_MAPS = new HashMap<String, String>();
    private static Logger logger = LoggerFactory.getLogger(FastDFSClient.class);
    private static final String FILENAME = "filename";
    private int maxFileSize = 100000000;

    public FastDFSClient() {
        this.initExt();
    }

    private void initExt() {
        EXT_MAPS.put("png", "image/png");
        EXT_MAPS.put("gif", "image/gif");
        EXT_MAPS.put("bmp", "image/bmp");
        EXT_MAPS.put("ico", "image/x-ico");
        EXT_MAPS.put("jpeg", "image/jpeg");
        EXT_MAPS.put("jpg", "image/jpeg");
        EXT_MAPS.put("zip", "application/zip");
        EXT_MAPS.put("rar", "application/x-rar");
        EXT_MAPS.put("pdf", "application/pdf");
        EXT_MAPS.put("ppt", "application/vnd.ms-powerpoint");
        EXT_MAPS.put("xls", "application/vnd.ms-excel");
        EXT_MAPS.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        EXT_MAPS.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        EXT_MAPS.put("doc", "application/msword");
        EXT_MAPS.put("doc", "application/wps-office.doc");
        EXT_MAPS.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        EXT_MAPS.put("txt", "text/plain");
        EXT_MAPS.put("mp4", "video/mp4");
        EXT_MAPS.put("flv", "video/x-flv");
    }

    public String uploadFileWithMultipart(MultipartFile file) throws FastDFSException {
        return this.upload(file, null);
    }

    public String uploadFileWithMultipart(MultipartFile file, Map<String, String> descriptions) throws FastDFSException {
        return this.upload(file, descriptions);
    }

    public String uploadFileWithFilepath(String filepath) throws FastDFSException {
        return this.upload(filepath, null);
    }

    public String uploadFileWithFilepath(String filepath, Map<String, String> descriptions) throws FastDFSException {
        return this.upload(filepath, descriptions);
    }

    public String uploadFileWithBase64(String base64) throws FastDFSException {
        return this.upload(base64, null, null);
    }

    public String uploadFileWithBase64(String base64, String filename) throws FastDFSException {
        return this.upload(base64, filename, null);
    }

    public String uploadFileWithBase64(String base64, String filename, Map<String, String> descriptions) throws FastDFSException {
        return this.upload(base64, filename, descriptions);
    }

    public String upload(MultipartFile file, Map<String, String> descriptions) throws FastDFSException {
        if (file == null || file.isEmpty()) {
            throw new FastDFSException(ErrorCode.FILE_ISNULL.CODE, ErrorCode.FILE_ISNULL.MESSAGE);
        }
        String path = null;
        try {
            path = this.upload(file.getInputStream(), file.getOriginalFilename(), descriptions);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FastDFSException(ErrorCode.FILE_ISNULL.CODE, ErrorCode.FILE_ISNULL.MESSAGE);
        }
        return path;
    }

    public String upload(String filepath, Map<String, String> descriptions) throws FastDFSException {
        if (StringUtils.isEmpty((Object)filepath)) {
            throw new FastDFSException(ErrorCode.FILE_PATH_ISNULL.CODE, ErrorCode.FILE_PATH_ISNULL.MESSAGE);
        }
        File file = new File(filepath);
        String path = null;
        try {
            FileInputStream is = new FileInputStream(file);
            filepath = FastDFSClient.toLocal(filepath);
            String filename = filepath.substring(filepath.lastIndexOf(SEPARATOR) + 1);
            path = this.upload(is, filename, descriptions);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new FastDFSException(ErrorCode.FILE_NOT_EXIST.CODE, ErrorCode.FILE_NOT_EXIST.MESSAGE);
        }
        return path;
    }

    public String upload(String base64, String filename, Map<String, String> descriptions) throws FastDFSException {
        if (StringUtils.isEmpty((Object)base64)) {
            throw new FastDFSException(ErrorCode.FILE_ISNULL.CODE, ErrorCode.FILE_ISNULL.MESSAGE);
        }
        return this.upload(new ByteArrayInputStream(Base64.decodeBase64((String)base64)), filename, descriptions);
    }

    public String upload(InputStream is, String filename, Map<String, String> descriptions) throws FastDFSException {
        if (is == null) {
            throw new FastDFSException(ErrorCode.FILE_ISNULL.CODE, ErrorCode.FILE_ISNULL.MESSAGE);
        }
        try {
            if (is.available() > this.maxFileSize) {
                throw new FastDFSException(ErrorCode.FILE_OUT_SIZE.CODE, ErrorCode.FILE_OUT_SIZE.MESSAGE);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        filename = FastDFSClient.toLocal(filename);
        String path = null;
        NameValuePair[] nvps = null;
        ArrayList<NameValuePair> nvpsList = new ArrayList<NameValuePair>();
        String suffix = FastDFSClient.getFilenameSuffix(filename);
        if (!StringUtils.isEmpty((Object)filename)) {
            nvpsList.add(new NameValuePair(FILENAME, filename));
        }
        if (descriptions != null && descriptions.size() > 0) {
            for (String key : descriptions.keySet()) {
                nvpsList.add(new NameValuePair(key, descriptions.get(key)));
            }
        }
        if (nvpsList.size() > 0) {
            nvps = new NameValuePair[nvpsList.size()];
            nvpsList.toArray(nvps);
        }
        TrackerServer trackerServer = TrackerServerPool.borrowObject();
        StorageClient1 storageClient = new StorageClient1(trackerServer, null);
        try {
            byte[] fileBuff = new byte[is.available()];
            is.read(fileBuff, 0, fileBuff.length);
            path = storageClient.upload_file1(fileBuff, suffix, nvps);
            if (StringUtils.isEmpty((Object)path)) {
                throw new FastDFSException(ErrorCode.FILE_UPLOAD_FAILED.CODE, ErrorCode.FILE_UPLOAD_FAILED.MESSAGE);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("upload file success, return path is {}", (Object)path);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FastDFSException(ErrorCode.FILE_UPLOAD_FAILED.CODE, ErrorCode.FILE_UPLOAD_FAILED.MESSAGE);
        }
        catch (MyException e) {
            e.printStackTrace();
            throw new FastDFSException(ErrorCode.FILE_UPLOAD_FAILED.CODE, ErrorCode.FILE_UPLOAD_FAILED.MESSAGE);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        TrackerServerPool.returnObject(trackerServer);
        return path;
    }

    public void downloadFile(String filepath, HttpServletResponse response) throws FastDFSException {
        this.download(filepath, null, null, response);
    }

    public void downloadFile(String filepath, OutputStream os) throws FastDFSException {
        this.download(filepath, null, os, null);
    }

    public void downloadFile(String filepath, String filename, HttpServletResponse response) throws FastDFSException {
        this.download(filepath, filename, null, response);
    }

    public void download(String filepath, String filename, OutputStream os, HttpServletResponse response) throws FastDFSException {
        if (StringUtils.isEmpty((Object)filepath)) {
            throw new FastDFSException(ErrorCode.FILE_PATH_ISNULL.CODE, ErrorCode.FILE_PATH_ISNULL.MESSAGE);
        }
        filepath = FastDFSClient.toLocal(filepath);
        if (StringUtils.isEmpty((Object)filename)) {
            filename = this.getOriginalFilename(filepath);
        }
        String contentType = EXT_MAPS.get(FastDFSClient.getFilenameSuffix(filename));
        if (logger.isDebugEnabled()) {
            logger.debug("download file, filepath = {}, filename = {}", (Object)filepath, (Object)filename);
        }
        TrackerServer trackerServer = TrackerServerPool.borrowObject();
        StorageClient1 storageClient = new StorageClient1(trackerServer, null);
        InputStream is = null;
        try {
            byte[] fileByte = storageClient.download_file1(filepath);
            if (fileByte == null) {
                throw new FastDFSException(ErrorCode.FILE_NOT_EXIST.CODE, ErrorCode.FILE_NOT_EXIST.MESSAGE);
            }
            if (response != null) {
                os = response.getOutputStream();
                if (!StringUtils.isEmpty((Object)contentType)) {
                    String encoderName = URLEncoder.encode(filename, "UTF-8").replace("+", "%20").replace("%2B", "+");
                    response.setHeader("Content-Disposition", "attachment;filename=\"" + encoderName + "\"");
                    response.setContentType(contentType + ";charset=UTF-8");
                    response.setHeader("Accept-Ranges", "bytes");
                }
            }
            is = new ByteArrayInputStream(fileByte);
            byte[] buffer = new byte[5120];
            int len = 0;
            while ((len = is.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
            os.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
            throw new FastDFSException(ErrorCode.FILE_DOWNLOAD_FAILED.CODE, ErrorCode.FILE_DOWNLOAD_FAILED.MESSAGE);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        TrackerServerPool.returnObject(trackerServer);
    }

    public byte[] download(String filepath) throws FastDFSException {
        if (StringUtils.isEmpty((Object)filepath)) {
            throw new FastDFSException(ErrorCode.FILE_PATH_ISNULL.CODE, ErrorCode.FILE_PATH_ISNULL.MESSAGE);
        }
        TrackerServer trackerServer = TrackerServerPool.borrowObject();
        StorageClient1 storageClient = new StorageClient1(trackerServer, null);
        Object is = null;
        byte[] fileByte = null;
        try {
            fileByte = storageClient.download_file1(filepath);
            if (fileByte == null) {
                throw new FastDFSException(ErrorCode.FILE_NOT_EXIST.CODE, ErrorCode.FILE_NOT_EXIST.MESSAGE);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
            throw new FastDFSException(ErrorCode.FILE_DOWNLOAD_FAILED.CODE, ErrorCode.FILE_DOWNLOAD_FAILED.MESSAGE);
        }
        TrackerServerPool.returnObject(trackerServer);
        return fileByte;
    }

    public int deleteFile(String filepath) throws FastDFSException {
        if (StringUtils.isEmpty((Object)filepath)) {
            throw new FastDFSException(ErrorCode.FILE_PATH_ISNULL.CODE, ErrorCode.FILE_PATH_ISNULL.MESSAGE);
        }
        TrackerServer trackerServer = TrackerServerPool.borrowObject();
        StorageClient1 storageClient = new StorageClient1(trackerServer, null);
        int success = 0;
        try {
            success = storageClient.delete_file1(filepath);
            if (success != 0) {
                throw new FastDFSException(ErrorCode.FILE_DELETE_FAILED.CODE, ErrorCode.FILE_DELETE_FAILED.MESSAGE);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
            throw new FastDFSException(ErrorCode.FILE_DELETE_FAILED.CODE, ErrorCode.FILE_DELETE_FAILED.MESSAGE);
        }
        TrackerServerPool.returnObject(trackerServer);
        return success;
    }

    public Map<String, Object> getFileInfo(String filepath) throws FastDFSException {
        TrackerServer trackerServer = TrackerServerPool.borrowObject();
        StorageClient1 storageClient = new StorageClient1(trackerServer, null);
        FileInfo fileInfo = null;
        try {
            fileInfo = storageClient.get_file_info1(filepath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
        }
        TrackerServerPool.returnObject(trackerServer);
        HashMap<String, Object> infoMap = new HashMap<String, Object>(4);
        infoMap.put("SourceIpAddr", fileInfo.getSourceIpAddr());
        infoMap.put("FileSize", fileInfo.getFileSize());
        infoMap.put("CreateTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(fileInfo.getCreateTimestamp()));
        infoMap.put("CRC32", fileInfo.getCrc32());
        return infoMap;
    }

    public Map<String, Object> getFileDescriptions(String filepath) throws FastDFSException {
        TrackerServer trackerServer = TrackerServerPool.borrowObject();
        StorageClient1 storageClient = new StorageClient1(trackerServer, null);
        NameValuePair[] nvps = null;
        try {
            nvps = storageClient.get_metadata1(filepath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
        }
        TrackerServerPool.returnObject(trackerServer);
        HashMap<String, String> infoMap = null;
        if (nvps != null && nvps.length > 0) {
            infoMap = new HashMap<String, String>(nvps.length);
            for (NameValuePair nvp : nvps) {
                infoMap.put(nvp.getName(), nvp.getValue());
            }
        }
        return infoMap;
    }

    public String getOriginalFilename(String filepath) throws FastDFSException {
        Map<String, Object> descriptions = this.getFileDescriptions(filepath);
        if (descriptions.get(FILENAME) != null) {
            return (String)descriptions.get(FILENAME);
        }
        return null;
    }

    public static String getFilenameSuffix(String filename) {
        String suffix = null;
        String originalFilename = filename;
        if (!StringUtils.isEmpty((Object)filename)) {
            if (filename.contains(SEPARATOR)) {
                filename = filename.substring(filename.lastIndexOf(SEPARATOR) + 1);
            }
            if (filename.contains(POINT)) {
                suffix = filename.substring(filename.lastIndexOf(POINT) + 1);
            } else if (logger.isErrorEnabled()) {
                logger.error("filename error without suffix : {}", (Object)originalFilename);
            }
        }
        return suffix;
    }

    public static String toLocal(String path) {
        if (StringUtils.isEmpty((Object)path) && (path = path.replaceAll("\\\\", SEPARATOR)).contains(POINT)) {
            String pre = path.substring(0, path.lastIndexOf(POINT) + 1);
            String suffix = path.substring(path.lastIndexOf(POINT) + 1).toLowerCase();
            path = pre + suffix;
        }
        return path;
    }

    public static String getFilename(String fileId) {
        String[] results = new String[2];
        StorageClient1.split_file_id((String)fileId, (String[])results);
        return results[1];
    }

    public static String getToken(String filepath, String httpSecretKey) {
        int ts = (int)(System.currentTimeMillis() / 1000L);
        String token = "null";
        try {
            token = ProtoCommon.getToken((String)FastDFSClient.getFilename(filepath), (int)ts, (String)httpSecretKey);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("token=").append(token);
        sb.append("&ts=").append(ts);
        return sb.toString();
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public static void main(String[] args) throws Exception {
    }
}

