/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.msyxy.attachment.fastdfs;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

public class FileCheck {
    private static final List<String> TYPE_IMAGE = new ArrayList<String>();
    private static final List<String> TYPE_DOC = new ArrayList<String>();
    private static final List<String> TYPE_VIDEO = new ArrayList<String>();
    private static final List<String> TYPE_COMPRESS = new ArrayList<String>();

    public static boolean checkImage(String filename) {
        return FileCheck.checkImage(null, filename);
    }

    public static boolean checkImage(List<String> types, String filename) {
        List<String> checkTypes = types;
        if (types == null || types.size() == 0) {
            checkTypes = TYPE_IMAGE;
        }
        return FileCheck.checkType(checkTypes, filename);
    }

    public static boolean checkDoc(String filename) {
        return FileCheck.checkDoc(null, filename);
    }

    public static boolean checkDoc(List<String> types, String filename) {
        List<String> checkTypes = types;
        if (types == null || types.size() == 0) {
            checkTypes = TYPE_DOC;
        }
        return FileCheck.checkType(checkTypes, filename);
    }

    public static boolean checkVideo(String filename) {
        return FileCheck.checkVideo(null, filename);
    }

    public static boolean checkVideo(List<String> types, String filename) {
        List<String> checkTypes = types;
        if (types == null || types.size() == 0) {
            checkTypes = TYPE_VIDEO;
        }
        return FileCheck.checkType(checkTypes, filename);
    }

    public static boolean checkCompress(String filename) {
        return FileCheck.checkCompress(null, filename);
    }

    public static boolean checkCompress(List<String> types, String filename) {
        List<String> checkTypes = types;
        if (types == null || types.size() == 0) {
            checkTypes = TYPE_COMPRESS;
        }
        return FileCheck.checkType(checkTypes, filename);
    }

    private static boolean checkType(List<String> checkTypes, String filename) {
        return checkTypes.contains(FileCheck.getFilenameSuffix(filename));
    }

    public static String getFilenameSuffix(String filename) {
        String suffix = null;
        if (!StringUtils.isEmpty((Object)filename) && filename.contains(".")) {
            suffix = filename.substring(filename.lastIndexOf(".") + 1).toLowerCase();
        }
        return suffix;
    }

    static {
        TYPE_IMAGE.add("png");
        TYPE_IMAGE.add("gif");
        TYPE_IMAGE.add("jpeg");
        TYPE_IMAGE.add("jpg");
        TYPE_DOC.add("pdf");
        TYPE_DOC.add("ppt");
        TYPE_DOC.add("xls");
        TYPE_DOC.add("xlsx");
        TYPE_DOC.add("pptx");
        TYPE_DOC.add("doc");
        TYPE_DOC.add("docx");
        TYPE_VIDEO.add("mp3");
        TYPE_VIDEO.add("mp4");
        TYPE_VIDEO.add("flv");
        TYPE_COMPRESS.add("zip");
        TYPE_COMPRESS.add("rar");
    }
}

