/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.msyxy.attachment.fastdfs;

import com.tcbj.msyxy.attachment.fastdfs.FastDFSException;
import com.tcbj.msyxy.attachment.fastdfs.TrackerServerFactory;
import java.io.IOException;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.csource.common.MyException;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class TrackerServerPool {
    private static Logger logger = LoggerFactory.getLogger(TrackerServerPool.class);
    private static final String FASTDFS_CONFIG_PATH = "application.properties";
    @Value(value="${max_storage_connection}")
    private static int maxStorageConnection;
    private static GenericObjectPool<TrackerServer> trackerServerPool;

    private TrackerServerPool() {
    }

    private static synchronized GenericObjectPool<TrackerServer> getObjectPool() {
        if (trackerServerPool == null) {
            try {
                ClientGlobal.initByProperties((String)FASTDFS_CONFIG_PATH);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (MyException e) {
                e.printStackTrace();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ClientGlobal configInfo: {}", (Object)ClientGlobal.configInfo());
            }
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMinIdle(2);
            if (maxStorageConnection > 0) {
                poolConfig.setMaxTotal(maxStorageConnection);
            }
            trackerServerPool = new GenericObjectPool((PooledObjectFactory)new TrackerServerFactory(), poolConfig);
        }
        return trackerServerPool;
    }

    public static TrackerServer borrowObject() throws FastDFSException {
        TrackerServer trackerServer;
        block2: {
            trackerServer = null;
            try {
                trackerServer = (TrackerServer)TrackerServerPool.getObjectPool().borrowObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!(e instanceof FastDFSException)) break block2;
                throw (FastDFSException)e;
            }
        }
        return trackerServer;
    }

    public static void returnObject(TrackerServer trackerServer) {
        TrackerServerPool.getObjectPool().returnObject((Object)trackerServer);
    }
}

