/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.bpm;

import com.tcbj.framework.bpm.Action;
import com.tcbj.framework.bpm.BpmActionChooser;
import com.tcbj.framework.bpm.BpmContext;
import com.tcbj.framework.bpm.BpmTransition;
import com.tcbj.framework.bpm.Event;
import com.tcbj.framework.bpm.SimpleActionChooser;
import com.tcbj.framework.bpm.SimpleBpmTransition;
import com.tcbj.framework.exception.exception.Thrower;
import java.util.HashMap;
import java.util.Map;

public class BpmNode<T> {
    private String nodeCode;
    private String nodeName;
    private Map<String, BpmTransition<T>> transitions = new HashMap<String, BpmTransition<T>>();
    private Map<String, BpmActionChooser<T>> actionMap = new HashMap<String, BpmActionChooser<T>>();

    public BpmNode(String nodeCode, String nodeName) {
        this.nodeCode = nodeCode;
        this.nodeName = nodeName;
    }

    public void clearTransition() {
        this.transitions.clear();
    }

    public void copyNode(BpmNode<T> node) {
        this.transitions.putAll(node.getTransitions());
        this.actionMap.putAll(node.getActionChoosers());
    }

    public Map<String, BpmTransition<T>> getTransitions() {
        return this.transitions;
    }

    public Map<String, BpmActionChooser<T>> getActionChoosers() {
        return this.actionMap;
    }

    public String getNodeCode() {
        return this.nodeCode;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public BpmNode<T> registTransition(Event event, Action action, BpmTransition<T> simpleBpmTransition) {
        if (this.transitions.get(event.getEventCode()) != null) {
            Thrower.throwAppException((String)"500", (String)"\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u6ce8\u518c\u4e00\u6837\u7684\u4e8b\u4ef6\uff0c\u731c\u4f60\u60f3\u914d\u7f6e\u6761\u4ef6\u6d41\u7a0b\u3002");
        }
        this.transitions.put(event.getEventCode(), simpleBpmTransition);
        this.actionMap.put(event.getEventCode(), SimpleActionChooser.of(action));
        return this;
    }

    public BpmNode<T> registTransition(Event event, Action action, BpmNode<T> nextNode) {
        if (this.transitions.get(event.getEventCode()) != null) {
            Thrower.throwAppException((String)"500", (String)"\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u6ce8\u518c\u4e00\u6837\u7684\u4e8b\u4ef6\uff0c\u731c\u4f60\u60f3\u914d\u7f6e\u6761\u4ef6\u6d41\u7a0b\u3002");
        }
        this.transitions.put(event.getEventCode(), SimpleBpmTransition.of(nextNode));
        this.actionMap.put(event.getEventCode(), SimpleActionChooser.of(action));
        return this;
    }

    public BpmNode<T> registTransition(Event event, BpmActionChooser actionChooser, BpmNode<T> nextNode) {
        if (this.transitions.get(event.getEventCode()) != null) {
            Thrower.throwAppException((String)"500", (String)"\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u6ce8\u518c\u4e00\u6837\u7684\u4e8b\u4ef6\uff0c\u731c\u4f60\u60f3\u914d\u7f6e\u6761\u4ef6\u6d41\u7a0b\u3002");
        }
        this.transitions.put(event.getEventCode(), SimpleBpmTransition.of(nextNode));
        this.actionMap.put(event.getEventCode(), actionChooser);
        return this;
    }

    public BpmNode<T> registTransition(Event event, BpmTransition<T> simpleBpmTransition) {
        if (this.transitions.get(event.getEventCode()) != null) {
            Thrower.throwAppException((String)"500", (String)"\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u6ce8\u518c\u4e00\u6837\u7684\u4e8b\u4ef6\uff0c\u731c\u4f60\u60f3\u914d\u7f6e\u6761\u4ef6\u6d41\u7a0b\u3002");
        }
        this.transitions.put(event.getEventCode(), simpleBpmTransition);
        return this;
    }

    public BpmNode<T> registTransition(Event event, BpmNode<T> nextNode) {
        if (this.transitions.get(event.getEventCode()) != null) {
            Thrower.throwAppException((String)"500", (String)"\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u6ce8\u518c\u4e00\u6837\u7684\u4e8b\u4ef6\uff0c\u731c\u4f60\u60f3\u914d\u7f6e\u6761\u4ef6\u6d41\u7a0b\u3002");
        }
        this.transitions.put(event.getEventCode(), SimpleBpmTransition.of(nextNode));
        return this;
    }

    public BpmTransition<T> getTrasition(Event event) {
        BpmTransition<T> eventTransitions = this.transitions.get(event.getEventCode());
        return eventTransitions;
    }

    public Action<T> getAction(Event event, BpmContext context) {
        BpmActionChooser<T> chooser = this.actionMap.get(event.getEventCode());
        return chooser.chooseAction(context);
    }
}

