/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.jdbc.keygen.ulid;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;

public class ULID {
    private static final char[] ENCODING_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private static final byte[] DECODING_CHARS = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 1, 18, 19, 1, 20, 21, 0, 22, 23, 24, 25, 26, -1, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 1, 18, 19, 1, 20, 21, 0, 22, 23, 24, 25, 26, -1, 27, 28, 29, 30, 31};
    private static final int MASK = 31;
    private static final int MASK_BITS = 5;
    private static final long TIMESTAMP_OVERFLOW_MASK = -281474976710656L;
    private static final long TIMESTAMP_MSB_MASK = -65536L;
    private static final long RANDOM_MSB_MASK = 65535L;
    private final Random random;

    public ULID() {
        this(new SecureRandom());
    }

    public ULID(Random random) {
        Objects.requireNonNull(random, "random must not be null!");
        this.random = random;
    }

    public void appendULID(StringBuilder stringBuilder) {
        Objects.requireNonNull(stringBuilder, "stringBuilder must not be null!");
        ULID.internalAppendULID(stringBuilder, System.currentTimeMillis(), this.random);
    }

    public String nextULID() {
        return this.nextULID(System.currentTimeMillis());
    }

    public String nextULID(long timestamp) {
        return ULID.internalUIDString(timestamp, this.random);
    }

    public Value nextValue() {
        return this.nextValue(System.currentTimeMillis());
    }

    public Value nextValue(long timestamp) {
        return ULID.internalNextValue(timestamp, this.random);
    }

    public Value nextMonotonicValue(Value previousUlid) {
        return this.nextMonotonicValue(previousUlid, System.currentTimeMillis());
    }

    public Value nextMonotonicValue(Value previousUlid, long timestamp) {
        Objects.requireNonNull(previousUlid, "previousUlid must not be null!");
        if (previousUlid.timestamp() == timestamp) {
            return previousUlid.increment();
        }
        return this.nextValue(timestamp);
    }

    public Optional<Value> nextStrictlyMonotonicValue(Value previousUlid) {
        return this.nextStrictlyMonotonicValue(previousUlid, System.currentTimeMillis());
    }

    public Optional<Value> nextStrictlyMonotonicValue(Value previousUlid, long timestamp) {
        Value result = this.nextMonotonicValue(previousUlid, timestamp);
        if (result.compareTo(previousUlid) < 1) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public static Value parseULID(String ulidString) {
        Objects.requireNonNull(ulidString, "ulidString must not be null!");
        if (ulidString.length() != 26) {
            throw new IllegalArgumentException("ulidString must be exactly 26 chars long.");
        }
        String timeString = ulidString.substring(0, 10);
        long time = ULID.internalParseCrockford(timeString);
        if ((time & 0xFFFF000000000000L) != 0L) {
            throw new IllegalArgumentException("ulidString must not exceed '7ZZZZZZZZZZZZZZZZZZZZZZZZZ'!");
        }
        String part1String = ulidString.substring(10, 18);
        String part2String = ulidString.substring(18);
        long part1 = ULID.internalParseCrockford(part1String);
        long part2 = ULID.internalParseCrockford(part2String);
        long most = time << 16 | part1 >>> 24;
        long least = part2 | part1 << 40;
        return new Value(most, least);
    }

    public static Value fromBytes(byte[] data) {
        int i;
        Objects.requireNonNull(data, "data must not be null!");
        if (data.length != 16) {
            throw new IllegalArgumentException("data must be 16 bytes in length!");
        }
        long mostSignificantBits = 0L;
        long leastSignificantBits = 0L;
        for (i = 0; i < 8; ++i) {
            mostSignificantBits = mostSignificantBits << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            leastSignificantBits = leastSignificantBits << 8 | (long)(data[i] & 0xFF);
        }
        return new Value(mostSignificantBits, leastSignificantBits);
    }

    static void internalAppendCrockford(StringBuilder builder, long value, int count) {
        for (int i = count - 1; i >= 0; --i) {
            int index = (int)(value >>> i * 5 & 0x1FL);
            builder.append(ENCODING_CHARS[index]);
        }
    }

    static long internalParseCrockford(String input) {
        Objects.requireNonNull(input, "input must not be null!");
        int length = input.length();
        if (length > 12) {
            throw new IllegalArgumentException("input length must not exceed 12 but was " + length + "!");
        }
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            char current = input.charAt(i);
            int value = -1;
            if (current < DECODING_CHARS.length) {
                value = DECODING_CHARS[current];
            }
            if (value < 0) {
                throw new IllegalArgumentException("Illegal character '" + current + "'!");
            }
            result |= (long)value << (length - 1 - i) * 5;
        }
        return result;
    }

    static void internalWriteCrockford(char[] buffer, long value, int count, int offset) {
        for (int i = 0; i < count; ++i) {
            int index = (int)(value >>> (count - i - 1) * 5 & 0x1FL);
            buffer[offset + i] = ENCODING_CHARS[index];
        }
    }

    static String internalUIDString(long timestamp, Random random) {
        ULID.checkTimestamp(timestamp);
        char[] buffer = new char[26];
        ULID.internalWriteCrockford(buffer, timestamp, 10, 0);
        ULID.internalWriteCrockford(buffer, random.nextLong(), 8, 10);
        ULID.internalWriteCrockford(buffer, random.nextLong(), 8, 18);
        return new String(buffer);
    }

    static void internalAppendULID(StringBuilder builder, long timestamp, Random random) {
        ULID.checkTimestamp(timestamp);
        ULID.internalAppendCrockford(builder, timestamp, 10);
        ULID.internalAppendCrockford(builder, random.nextLong(), 8);
        ULID.internalAppendCrockford(builder, random.nextLong(), 8);
    }

    static Value internalNextValue(long timestamp, Random random) {
        ULID.checkTimestamp(timestamp);
        long mostSignificantBits = random.nextLong();
        long leastSignificantBits = random.nextLong();
        mostSignificantBits &= 0xFFFFL;
        return new Value(mostSignificantBits |= timestamp << 16, leastSignificantBits);
    }

    private static void checkTimestamp(long timestamp) {
        if ((timestamp & 0xFFFF000000000000L) != 0L) {
            throw new IllegalArgumentException("ULID does not support timestamps after +10889-08-02T05:31:50.655Z!");
        }
    }

    public static class Value
    implements Comparable<Value>,
    Serializable {
        private static final long serialVersionUID = -3563159514112487717L;
        private final long mostSignificantBits;
        private final long leastSignificantBits;

        public Value(long mostSignificantBits, long leastSignificantBits) {
            this.mostSignificantBits = mostSignificantBits;
            this.leastSignificantBits = leastSignificantBits;
        }

        public long getMostSignificantBits() {
            return this.mostSignificantBits;
        }

        public long getLeastSignificantBits() {
            return this.leastSignificantBits;
        }

        public long timestamp() {
            return this.mostSignificantBits >>> 16;
        }

        public byte[] toBytes() {
            int i;
            byte[] result = new byte[16];
            for (i = 0; i < 8; ++i) {
                result[i] = (byte)(this.mostSignificantBits >> (7 - i) * 8 & 0xFFL);
            }
            for (i = 8; i < 16; ++i) {
                result[i] = (byte)(this.leastSignificantBits >> (15 - i) * 8 & 0xFFL);
            }
            return result;
        }

        public Value increment() {
            long lsb = this.leastSignificantBits;
            if (lsb != -1L) {
                return new Value(this.mostSignificantBits, lsb + 1L);
            }
            long msb = this.mostSignificantBits;
            if ((msb & 0xFFFFL) != 65535L) {
                return new Value(msb + 1L, 0L);
            }
            return new Value(msb & 0xFFFFFFFFFFFF0000L, 0L);
        }

        public int hashCode() {
            long hilo = this.mostSignificantBits ^ this.leastSignificantBits;
            return (int)(hilo >> 32) ^ (int)hilo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            return this.mostSignificantBits == value.mostSignificantBits && this.leastSignificantBits == value.leastSignificantBits;
        }

        @Override
        public int compareTo(Value val) {
            return this.mostSignificantBits < val.mostSignificantBits ? -1 : (this.mostSignificantBits > val.mostSignificantBits ? 1 : (this.leastSignificantBits < val.leastSignificantBits ? -1 : (this.leastSignificantBits > val.leastSignificantBits ? 1 : 0)));
        }

        public String toString() {
            char[] buffer = new char[26];
            ULID.internalWriteCrockford(buffer, this.timestamp(), 10, 0);
            long value = (this.mostSignificantBits & 0xFFFFL) << 24;
            long interim = this.leastSignificantBits >>> 40;
            ULID.internalWriteCrockford(buffer, value |= interim, 8, 10);
            ULID.internalWriteCrockford(buffer, this.leastSignificantBits, 8, 18);
            return new String(buffer);
        }
    }
}

