/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.jdbc.keygen.ulid;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;

public class ULID {
    private static final char[] ENCODING_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private static final byte[] DECODING_CHARS;
    private static final int MASK = 31;
    private static final int MASK_BITS = 5;
    private static final long TIMESTAMP_OVERFLOW_MASK = -281474976710656L;
    private static final long TIMESTAMP_MSB_MASK = -65536L;
    private static final long RANDOM_MSB_MASK = 65535L;
    private final Random random;

    static {
        byte[] byArray = new byte[123];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = -1;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[49] = 1;
        byArray[50] = 2;
        byArray[51] = 3;
        byArray[52] = 4;
        byArray[53] = 5;
        byArray[54] = 6;
        byArray[55] = 7;
        byArray[56] = 8;
        byArray[57] = 9;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[65] = 10;
        byArray[66] = 11;
        byArray[67] = 12;
        byArray[68] = 13;
        byArray[69] = 14;
        byArray[70] = 15;
        byArray[71] = 16;
        byArray[72] = 17;
        byArray[73] = 1;
        byArray[74] = 18;
        byArray[75] = 19;
        byArray[76] = 1;
        byArray[77] = 20;
        byArray[78] = 21;
        byArray[80] = 22;
        byArray[81] = 23;
        byArray[82] = 24;
        byArray[83] = 25;
        byArray[84] = 26;
        byArray[85] = -1;
        byArray[86] = 27;
        byArray[87] = 28;
        byArray[88] = 29;
        byArray[89] = 30;
        byArray[90] = 31;
        byArray[91] = -1;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[94] = -1;
        byArray[95] = -1;
        byArray[96] = -1;
        byArray[97] = 10;
        byArray[98] = 11;
        byArray[99] = 12;
        byArray[100] = 13;
        byArray[101] = 14;
        byArray[102] = 15;
        byArray[103] = 16;
        byArray[104] = 17;
        byArray[105] = 1;
        byArray[106] = 18;
        byArray[107] = 19;
        byArray[108] = 1;
        byArray[109] = 20;
        byArray[110] = 21;
        byArray[112] = 22;
        byArray[113] = 23;
        byArray[114] = 24;
        byArray[115] = 25;
        byArray[116] = 26;
        byArray[117] = -1;
        byArray[118] = 27;
        byArray[119] = 28;
        byArray[120] = 29;
        byArray[121] = 30;
        byArray[122] = 31;
        DECODING_CHARS = byArray;
    }

    public ULID() {
        this(new SecureRandom());
    }

    public ULID(Random random) {
        Objects.requireNonNull(random, "random must not be null!");
        this.random = random;
    }

    public void appendULID(StringBuilder stringBuilder) {
        Objects.requireNonNull(stringBuilder, "stringBuilder must not be null!");
        ULID.internalAppendULID(stringBuilder, System.currentTimeMillis(), this.random);
    }

    public String nextULID() {
        return this.nextULID(System.currentTimeMillis());
    }

    public String nextULID(long timestamp) {
        return ULID.internalUIDString(timestamp, this.random);
    }

    public Value nextValue() {
        return this.nextValue(System.currentTimeMillis());
    }

    public Value nextValue(long timestamp) {
        return ULID.internalNextValue(timestamp, this.random);
    }

    public Value nextMonotonicValue(Value previousUlid) {
        return this.nextMonotonicValue(previousUlid, System.currentTimeMillis());
    }

    public Value nextMonotonicValue(Value previousUlid, long timestamp) {
        Objects.requireNonNull(previousUlid, "previousUlid must not be null!");
        if (previousUlid.timestamp() == timestamp) {
            return previousUlid.increment();
        }
        return this.nextValue(timestamp);
    }

    public Optional<Value> nextStrictlyMonotonicValue(Value previousUlid) {
        return this.nextStrictlyMonotonicValue(previousUlid, System.currentTimeMillis());
    }

    public Optional<Value> nextStrictlyMonotonicValue(Value previousUlid, long timestamp) {
        Value result = this.nextMonotonicValue(previousUlid, timestamp);
        if (result.compareTo(previousUlid) < 1) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public static Value parseULID(String ulidString) {
        Objects.requireNonNull(ulidString, "ulidString must not be null!");
        if (ulidString.length() != 26) {
            throw new IllegalArgumentException("ulidString must be exactly 26 chars long.");
        }
        String timeString = ulidString.substring(0, 10);
        long time = ULID.internalParseCrockford(timeString);
        if ((time & 0xFFFF000000000000L) != 0L) {
            throw new IllegalArgumentException("ulidString must not exceed '7ZZZZZZZZZZZZZZZZZZZZZZZZZ'!");
        }
        String part1String = ulidString.substring(10, 18);
        String part2String = ulidString.substring(18);
        long part1 = ULID.internalParseCrockford(part1String);
        long part2 = ULID.internalParseCrockford(part2String);
        long most = time << 16 | part1 >>> 24;
        long least = part2 | part1 << 40;
        return new Value(most, least);
    }

    public static Value fromBytes(byte[] data) {
        Objects.requireNonNull(data, "data must not be null!");
        if (data.length != 16) {
            throw new IllegalArgumentException("data must be 16 bytes in length!");
        }
        long mostSignificantBits = 0L;
        long leastSignificantBits = 0L;
        int i = 0;
        while (i < 8) {
            mostSignificantBits = mostSignificantBits << 8 | (long)(data[i] & 0xFF);
            ++i;
        }
        i = 8;
        while (i < 16) {
            leastSignificantBits = leastSignificantBits << 8 | (long)(data[i] & 0xFF);
            ++i;
        }
        return new Value(mostSignificantBits, leastSignificantBits);
    }

    static void internalAppendCrockford(StringBuilder builder, long value, int count) {
        int i = count - 1;
        while (i >= 0) {
            int index = (int)(value >>> i * 5 & 0x1FL);
            builder.append(ENCODING_CHARS[index]);
            --i;
        }
    }

    static long internalParseCrockford(String input) {
        Objects.requireNonNull(input, "input must not be null!");
        int length = input.length();
        if (length > 12) {
            throw new IllegalArgumentException("input length must not exceed 12 but was " + length + "!");
        }
        long result = 0L;
        int i = 0;
        while (i < length) {
            char current = input.charAt(i);
            int value = -1;
            if (current < DECODING_CHARS.length) {
                value = DECODING_CHARS[current];
            }
            if (value < 0) {
                throw new IllegalArgumentException("Illegal character '" + current + "'!");
            }
            result |= (long)value << (length - 1 - i) * 5;
            ++i;
        }
        return result;
    }

    static void internalWriteCrockford(char[] buffer, long value, int count, int offset) {
        int i = 0;
        while (i < count) {
            int index = (int)(value >>> (count - i - 1) * 5 & 0x1FL);
            buffer[offset + i] = ENCODING_CHARS[index];
            ++i;
        }
    }

    static String internalUIDString(long timestamp, Random random) {
        ULID.checkTimestamp(timestamp);
        char[] buffer = new char[26];
        ULID.internalWriteCrockford(buffer, timestamp, 10, 0);
        ULID.internalWriteCrockford(buffer, random.nextLong(), 8, 10);
        ULID.internalWriteCrockford(buffer, random.nextLong(), 8, 18);
        return new String(buffer);
    }

    static void internalAppendULID(StringBuilder builder, long timestamp, Random random) {
        ULID.checkTimestamp(timestamp);
        ULID.internalAppendCrockford(builder, timestamp, 10);
        ULID.internalAppendCrockford(builder, random.nextLong(), 8);
        ULID.internalAppendCrockford(builder, random.nextLong(), 8);
    }

    static Value internalNextValue(long timestamp, Random random) {
        ULID.checkTimestamp(timestamp);
        long mostSignificantBits = random.nextLong();
        long leastSignificantBits = random.nextLong();
        mostSignificantBits &= 0xFFFFL;
        return new Value(mostSignificantBits |= timestamp << 16, leastSignificantBits);
    }

    private static void checkTimestamp(long timestamp) {
        if ((timestamp & 0xFFFF000000000000L) != 0L) {
            throw new IllegalArgumentException("ULID does not support timestamps after +10889-08-02T05:31:50.655Z!");
        }
    }

    public static class Value
    implements Comparable<Value>,
    Serializable {
        private static final long serialVersionUID = -3563159514112487717L;
        private final long mostSignificantBits;
        private final long leastSignificantBits;

        public Value(long mostSignificantBits, long leastSignificantBits) {
            this.mostSignificantBits = mostSignificantBits;
            this.leastSignificantBits = leastSignificantBits;
        }

        public long getMostSignificantBits() {
            return this.mostSignificantBits;
        }

        public long getLeastSignificantBits() {
            return this.leastSignificantBits;
        }

        public long timestamp() {
            return this.mostSignificantBits >>> 16;
        }

        public byte[] toBytes() {
            byte[] result = new byte[16];
            int i = 0;
            while (i < 8) {
                result[i] = (byte)(this.mostSignificantBits >> (7 - i) * 8 & 0xFFL);
                ++i;
            }
            i = 8;
            while (i < 16) {
                result[i] = (byte)(this.leastSignificantBits >> (15 - i) * 8 & 0xFFL);
                ++i;
            }
            return result;
        }

        public Value increment() {
            long lsb = this.leastSignificantBits;
            if (lsb != -1L) {
                return new Value(this.mostSignificantBits, lsb + 1L);
            }
            long msb = this.mostSignificantBits;
            if ((msb & 0xFFFFL) != 65535L) {
                return new Value(msb + 1L, 0L);
            }
            return new Value(msb & 0xFFFFFFFFFFFF0000L, 0L);
        }

        public int hashCode() {
            long hilo = this.mostSignificantBits ^ this.leastSignificantBits;
            return (int)(hilo >> 32) ^ (int)hilo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            return this.mostSignificantBits == value.mostSignificantBits && this.leastSignificantBits == value.leastSignificantBits;
        }

        @Override
        public int compareTo(Value val) {
            return this.mostSignificantBits < val.mostSignificantBits ? -1 : (this.mostSignificantBits > val.mostSignificantBits ? 1 : (this.leastSignificantBits < val.leastSignificantBits ? -1 : (this.leastSignificantBits > val.leastSignificantBits ? 1 : 0)));
        }

        public String toString() {
            char[] buffer = new char[26];
            ULID.internalWriteCrockford(buffer, this.timestamp(), 10, 0);
            long value = (this.mostSignificantBits & 0xFFFFL) << 24;
            long interim = this.leastSignificantBits >>> 40;
            ULID.internalWriteCrockford(buffer, value |= interim, 8, 10);
            ULID.internalWriteCrockford(buffer, this.leastSignificantBits, 8, 18);
            return new String(buffer);
        }
    }
}

