/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.ms.loadbalance.nacos;

import com.alibaba.cloud.nacos.ribbon.NacosServer;
import com.alibaba.nacos.client.naming.utils.Chooser;
import com.alibaba.nacos.client.naming.utils.Pair;
import com.alibaba.nacos.client.utils.LogUtils;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import com.tcbj.framework.ms.loadbalance.contract.TcbjLoadbalanceEnum;
import com.tcbj.framework.ms.loadbalance.nacos.TcbjSpringClientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.util.CollectionUtils;

public class MetadataRule
extends AbstractLoadBalancerRule {
    private static Logger LOGGER = LoggerFactory.getLogger(MetadataRule.class);

    public MetadataRule() {
    }

    public MetadataRule(ILoadBalancer lb) {
        this();
        this.setLoadBalancer(lb);
    }

    public Server choose(ILoadBalancer lb, Object key) {
        try {
            String version = null;
            try {
                HttpRequest request = (HttpRequest)key;
                version = (String)request.getHeaders().get((Object)TcbjLoadbalanceEnum.HEAD_INDICATOR).get(0);
                LOGGER.debug(" detect version in request head:" + version);
            }
            catch (Exception ex) {
                LOGGER.debug("get header error", (Throwable)ex);
                LOGGER.debug(" no version in request head");
            }
            TcbjSpringClientFactory.CustomLoadBalancer loadBalancer = (TcbjSpringClientFactory.CustomLoadBalancer)lb;
            List<Server> servers = loadBalancer.getAllServers();
            List<NacosServer> nacosServers = this.toNacosServer(servers);
            List<Object> nacosServerToChoose = new ArrayList();
            if (version != null && !"".equals(version.trim())) {
                ArrayList<NacosServer> filterInstances = new ArrayList<NacosServer>();
                for (NacosServer i2 : nacosServers) {
                    if (!Objects.equals(version, i2.getMetadata().get(TcbjLoadbalanceEnum.HEAD_INDICATOR))) continue;
                    filterInstances.add(i2);
                }
                nacosServerToChoose = CollectionUtils.isEmpty(filterInstances) ? nacosServers.stream().filter(i -> i.getMetadata().get(TcbjLoadbalanceEnum.HEAD_INDICATOR) == null).collect(Collectors.toList()) : filterInstances;
            } else {
                nacosServerToChoose = nacosServers.stream().filter(i -> i.getMetadata().get(TcbjLoadbalanceEnum.HEAD_INDICATOR) == null).collect(Collectors.toList());
            }
            NacosServer target = MetadataRule.getHostByRandomWeight(nacosServerToChoose);
            LOGGER.debug(loadBalancer.getName() + ",loadbalance rule choose server:" + target.getHostPort());
            return target;
        }
        catch (Exception var9) {
            LOGGER.warn("MetadataRule error", (Throwable)var9);
            return null;
        }
    }

    private List<NacosServer> toNacosServer(List<Server> servers) {
        List<NacosServer> nacosServers = servers.stream().map(s -> (NacosServer)s).collect(Collectors.toList());
        return nacosServers;
    }

    protected static NacosServer getHostByRandomWeight(List<NacosServer> hosts) {
        LogUtils.NAMING_LOGGER.debug("entry randomWithWeight");
        if (hosts == null || hosts.size() == 0) {
            LogUtils.NAMING_LOGGER.debug("hosts == null || hosts.size() == 0");
            return null;
        }
        Chooser vipChooser = new Chooser((Object)"by-health.com");
        LogUtils.NAMING_LOGGER.debug("new Chooser");
        ArrayList<Pair> hostsWithWeight = new ArrayList<Pair>();
        for (NacosServer host : hosts) {
            if (!host.isAlive()) continue;
            hostsWithWeight.add(new Pair((Object)host, host.getInstance().getWeight()));
        }
        LogUtils.NAMING_LOGGER.debug("for (Host host : hosts)");
        vipChooser.refresh(hostsWithWeight);
        LogUtils.NAMING_LOGGER.debug("vipChooser.refresh");
        return (NacosServer)vipChooser.randomWithWeight();
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
    }

    public Server choose(Object key) {
        return this.choose(this.getLoadBalancer(), key);
    }
}

