/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.ms.loadbalance.nacos;

import com.netflix.client.ClientException;
import com.netflix.client.ClientRequest;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import org.springframework.cloud.openfeign.ribbon.FeignLoadBalancer;

public class TcbjFeignLoadBalancer
extends FeignLoadBalancer {
    private FeignLoadBalancer feignLoadBalancer;
    private static Method toHttpRequestMethod;

    public TcbjFeignLoadBalancer(FeignLoadBalancer feignLoadBalancer) {
        super(null, (IClientConfig)new RouterIClientConfig(), null);
        this.feignLoadBalancer = feignLoadBalancer;
    }

    private Object invokeToHttpRequest(FeignLoadBalancer.RibbonRequest request) {
        try {
            return toHttpRequestMethod.invoke((Object)request, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void customizeLoadBalancerCommandBuilder(FeignLoadBalancer.RibbonRequest request, IClientConfig config, LoadBalancerCommand.Builder<FeignLoadBalancer.RibbonResponse> builder) {
        builder.withServerLocator(this.invokeToHttpRequest(request));
    }

    public Server getServerFromLoadBalancer(URI original, Object loadBalancerKey) throws ClientException {
        return this.feignLoadBalancer.getServerFromLoadBalancer(original, loadBalancerKey);
    }

    public FeignLoadBalancer.RibbonResponse execute(FeignLoadBalancer.RibbonRequest request, IClientConfig configOverride) throws IOException {
        return this.feignLoadBalancer.execute(request, configOverride);
    }

    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(FeignLoadBalancer.RibbonRequest request, IClientConfig requestConfig) {
        return this.feignLoadBalancer.getRequestSpecificRetryHandler(request, requestConfig);
    }

    public URI reconstructURIWithServer(Server server, URI original) {
        return this.feignLoadBalancer.reconstructURIWithServer(server, original);
    }

    public FeignLoadBalancer.RibbonResponse executeWithLoadBalancer(FeignLoadBalancer.RibbonRequest request) throws ClientException {
        return (FeignLoadBalancer.RibbonResponse)super.executeWithLoadBalancer((ClientRequest)request);
    }

    public FeignLoadBalancer.RibbonResponse executeWithLoadBalancer(FeignLoadBalancer.RibbonRequest request, IClientConfig requestConfig) throws ClientException {
        return (FeignLoadBalancer.RibbonResponse)super.executeWithLoadBalancer((ClientRequest)request, requestConfig);
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        if (this.feignLoadBalancer != null) {
            this.feignLoadBalancer.initWithNiwsConfig(clientConfig);
        }
    }

    public String getClientName() {
        return this.feignLoadBalancer.getClientName();
    }

    public ILoadBalancer getLoadBalancer() {
        return this.feignLoadBalancer.getLoadBalancer();
    }

    public void setLoadBalancer(ILoadBalancer lb) {
        this.feignLoadBalancer.setLoadBalancer(lb);
    }

    public int getMaxAutoRetriesNextServer() {
        return this.feignLoadBalancer.getMaxAutoRetriesNextServer();
    }

    public void setMaxAutoRetriesNextServer(int maxAutoRetriesNextServer) {
        this.feignLoadBalancer.setMaxAutoRetriesNextServer(maxAutoRetriesNextServer);
    }

    public int getMaxAutoRetries() {
        return this.feignLoadBalancer.getMaxAutoRetries();
    }

    public void setMaxAutoRetries(int maxAutoRetries) {
        this.feignLoadBalancer.setMaxAutoRetries(maxAutoRetries);
    }

    public void noteRequestCompletion(ServerStats stats, Object response, Throwable e, long responseTime, RetryHandler errorHandler) {
        this.feignLoadBalancer.noteRequestCompletion(stats, response, e, responseTime, errorHandler);
    }

    public void noteOpenConnection(ServerStats serverStats) {
        this.feignLoadBalancer.noteOpenConnection(serverStats);
    }

    public boolean handleSameServerRetry(Server server, int currentRetryCount, int maxRetries, Throwable e) {
        return this.feignLoadBalancer.handleSameServerRetry(server, currentRetryCount, maxRetries, e);
    }

    static {
        try {
            toHttpRequestMethod = FeignLoadBalancer.RibbonRequest.class.getDeclaredMethod("toHttpRequest", new Class[0]);
            toHttpRequestMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static class RouterIClientConfig
    extends DefaultClientConfigImpl {
        public <T> T get(IClientConfigKey<T> key) {
            if (key == CommonClientConfigKey.ConnectTimeout || key == CommonClientConfigKey.ReadTimeout) {
                return (T)Integer.valueOf(-1);
            }
            return (T)super.get(key);
        }
    }
}

