/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.ms.loadbalance.nacos;

import com.netflix.loadbalancer.BaseLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.tcbj.framework.ms.loadbalance.nacos.MetadataRule;
import java.util.List;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;

public class TcbjSpringClientFactory
extends SpringClientFactory {
    private SpringClientFactory factory;

    public TcbjSpringClientFactory(SpringClientFactory factory) {
        this.factory = factory;
    }

    public ILoadBalancer getLoadBalancer(String name) {
        return new CustomLoadBalancer(this.factory.getLoadBalancer(name));
    }

    public static class CustomLoadBalancer
    extends BaseLoadBalancer {
        private ILoadBalancer loadBalancer;

        public CustomLoadBalancer(ILoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            this.setRule((IRule)new MetadataRule((ILoadBalancer)this));
        }

        public void addServers(List<Server> newServers) {
            this.loadBalancer.addServers(newServers);
        }

        public void markServerDown(Server server) {
            this.loadBalancer.markServerDown(server);
        }

        public List<Server> getServerList(boolean availableOnly) {
            return this.loadBalancer.getServerList(availableOnly);
        }

        public List<Server> getReachableServers() {
            return this.loadBalancer.getReachableServers();
        }

        public List<Server> getAllServers() {
            return this.loadBalancer.getAllServers();
        }
    }
}

