/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.util.excel;

import com.tcbj.framework.util.excel.ExcelExportHandler;
import com.tcbj.framework.util.excel.ExcelResultWriter;
import com.tcbj.framework.util.excel.ExcelVersion;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelMultiSheetCreator {
    private ExcelVersion version;
    private List<InnerSheet> innerSheets = new ArrayList<InnerSheet>();

    public ExcelMultiSheetCreator(ExcelVersion version) {
        this.version = version;
    }

    public static ExcelMultiSheetCreator New2003() {
        return new ExcelMultiSheetCreator(ExcelVersion.EXCEL_2003);
    }

    public static ExcelMultiSheetCreator New2007() {
        return new ExcelMultiSheetCreator(ExcelVersion.EXCEL_2007);
    }

    public InnerSheet addSheet(String sheetName) {
        InnerSheet innerSheet = new InnerSheet(sheetName);
        this.innerSheets.add(innerSheet);
        return innerSheet;
    }

    public ExcelResultWriter create() throws Exception {
        Workbook workbook = this.getWorkbook(this.version);
        for (InnerSheet shet : this.innerSheets) {
            int i;
            Sheet sheet = workbook.createSheet(shet.getSheetName());
            String[] titils = shet.getTitles();
            String[] props = shet.getProps();
            List data = shet.getData();
            Row row = sheet.createRow(0);
            for (i = 0; i < titils.length; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellValue(titils[i]);
            }
            for (i = 0; i < data.size(); ++i) {
                boolean isMap;
                row = sheet.createRow(i + 1);
                Object obj = data.get(i);
                if (shet.getHandler() != null) {
                    shet.getHandler().invoke(obj);
                }
                boolean bl = isMap = Map.class.isAssignableFrom(obj.getClass());
                if (isMap) {
                    Map map = (Map)obj;
                    List<String> prop = Arrays.asList(props);
                    for (int j = 0; j < prop.size(); ++j) {
                        Cell cell = row.createCell(j);
                        Object result = map.get(prop.get(j));
                        cell.setCellValue(result == null ? "" : result.toString());
                    }
                    continue;
                }
                List<String> prop = Arrays.asList(props);
                for (int j = 0; j < prop.size(); ++j) {
                    Cell cell = row.createCell(j);
                    Object result = this.getPropValue(obj.getClass(), obj, prop.get(j));
                    cell.setCellValue(result == null ? "" : result.toString());
                }
            }
        }
        ExcelResultWriter writer = new ExcelResultWriter(workbook);
        return writer;
    }

    private Workbook getWorkbook(ExcelVersion version) throws Exception {
        HSSFWorkbook wb = null;
        if (ExcelVersion.EXCEL_2003 == version) {
            wb = new HSSFWorkbook();
        } else if (ExcelVersion.EXCEL_2007 == version) {
            wb = new XSSFWorkbook();
        } else {
            throw new RuntimeException("Unsuport version of the excel type");
        }
        return wb;
    }

    private Object getPropValue(Class clazz, Object obj, String prop) throws Exception {
        String getName = "get" + prop.substring(0, 1).toUpperCase(Locale.ENGLISH) + prop.substring(1);
        Method rM = clazz.getMethod(getName, new Class[0]);
        return rM.invoke(obj, new Object[0]);
    }

    class InnerSheet<T> {
        private String[] titles;
        private String[] props;
        private List<T> data;
        private String sheetName;
        private ExcelExportHandler handler;

        public InnerSheet(String sheetName) {
            this.sheetName = sheetName;
        }

        public InnerSheet titles(String[] titles) {
            this.titles = titles;
            return this;
        }

        public InnerSheet props(String[] props) {
            this.props = props;
            return this;
        }

        public InnerSheet dataSource(List<T> data) {
            this.data = data;
            return this;
        }

        public InnerSheet handler(ExcelExportHandler handler) {
            this.handler = handler;
            return this;
        }

        public String[] getTitles() {
            return this.titles;
        }

        public String[] getProps() {
            return this.props;
        }

        public List<T> getData() {
            return this.data;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public ExcelExportHandler getHandler() {
            return this.handler;
        }
    }
}

