/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.util.math;

import java.math.BigDecimal;

public class MoneyUtils {
    public static BigDecimal add(BigDecimal b1, BigDecimal ... bn) {
        if (b1 == null) {
            b1 = BigDecimal.ZERO;
        }
        if (bn != null) {
            BigDecimal[] bigDecimalArray = bn;
            int n = bn.length;
            int n2 = 0;
            while (n2 < n) {
                BigDecimal b = bigDecimalArray[n2];
                b1 = b1.add(b == null ? BigDecimal.ZERO : b);
                ++n2;
            }
        }
        return b1;
    }

    public static BigDecimal subtract(BigDecimal b1, BigDecimal ... bn) {
        return MoneyUtils.subtract(false, b1, bn);
    }

    public static BigDecimal subtract(Boolean isZero, BigDecimal b1, BigDecimal ... bn) {
        if (b1 == null) {
            b1 = BigDecimal.ZERO;
        }
        BigDecimal r = b1;
        if (bn != null) {
            BigDecimal[] bigDecimalArray = bn;
            int n = bn.length;
            int n2 = 0;
            while (n2 < n) {
                BigDecimal b = bigDecimalArray[n2];
                r = r.subtract(b == null ? BigDecimal.ZERO : b);
                ++n2;
            }
        }
        return isZero.booleanValue() ? (r.compareTo(BigDecimal.ZERO) == -1 ? BigDecimal.ZERO : r) : r;
    }

    public static <T extends Number> BigDecimal divide(T b1, T b2, int scale) {
        return MoneyUtils.divide(b1, b2, scale, BigDecimal.ZERO);
    }

    public static <T extends Number> BigDecimal divide(T b1, T b2, int scale, BigDecimal defaultValue) {
        if (b1 == null || b2 == null) {
            return defaultValue;
        }
        try {
            return BigDecimal.valueOf(b1.doubleValue()).divide(BigDecimal.valueOf(b2.doubleValue()), scale, 4);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <T extends Number> BigDecimal multiply(T b1, T b2, int scale) {
        if (b1 == null || b2 == null) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(b1.doubleValue()).multiply(BigDecimal.valueOf(b2.doubleValue())).setScale(scale, 4);
    }

    public static boolean gt(BigDecimal source, BigDecimal target) {
        return source.compareTo(target) > 0;
    }

    public static boolean lt(BigDecimal source, BigDecimal target) {
        return source.compareTo(target) < 0;
    }

    public static boolean et(BigDecimal source, BigDecimal target) {
        return source.compareTo(target) == 0;
    }

    public static boolean egt(BigDecimal source, BigDecimal target) {
        return source.compareTo(target) >= 0;
    }

    public static boolean elt(BigDecimal source, BigDecimal target) {
        return source.compareTo(target) <= 0;
    }

    @Deprecated
    public static double scale(double d, int scale) {
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        bigDecimal.setScale(scale);
        return bigDecimal.doubleValue();
    }
}

