/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.util.math;

import java.math.BigDecimal;

public class MoneyUtils {
    public static BigDecimal add(BigDecimal b1, BigDecimal ... bn) {
        if (null == b1) {
            b1 = BigDecimal.ZERO;
        }
        if (null != bn) {
            for (BigDecimal b : bn) {
                b1 = b1.add(null == b ? BigDecimal.ZERO : b);
            }
        }
        return b1;
    }

    public static BigDecimal subtract(BigDecimal b1, BigDecimal ... bn) {
        return MoneyUtils.subtract(false, b1, bn);
    }

    public static BigDecimal subtract(Boolean isZero, BigDecimal b1, BigDecimal ... bn) {
        if (null == b1) {
            b1 = BigDecimal.ZERO;
        }
        BigDecimal r = b1;
        if (null != bn) {
            for (BigDecimal b : bn) {
                r = r.subtract(null == b ? BigDecimal.ZERO : b);
            }
        }
        return isZero.booleanValue() ? (r.compareTo(BigDecimal.ZERO) == -1 ? BigDecimal.ZERO : r) : r;
    }

    public static <T extends Number> BigDecimal divide(T b1, T b2, int scale) {
        return MoneyUtils.divide(b1, b2, scale, BigDecimal.ZERO);
    }

    public static <T extends Number> BigDecimal divide(T b1, T b2, int scale, BigDecimal defaultValue) {
        if (null == b1 || null == b2) {
            return defaultValue;
        }
        try {
            return BigDecimal.valueOf(b1.doubleValue()).divide(BigDecimal.valueOf(b2.doubleValue()), scale, 4);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <T extends Number> BigDecimal multiply(T b1, T b2, int scale) {
        if (null == b1 || null == b2) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(b1.doubleValue()).multiply(BigDecimal.valueOf(b2.doubleValue())).setScale(scale, 4);
    }

    public static boolean gt(BigDecimal source, BigDecimal target) {
        return source.compareTo(target) > 0;
    }

    public static boolean lt(BigDecimal source, BigDecimal target) {
        return source.compareTo(target) < 0;
    }

    public static boolean et(BigDecimal source, BigDecimal target) {
        return source.compareTo(target) == 0;
    }

    public static boolean egt(BigDecimal source, BigDecimal target) {
        return source.compareTo(target) >= 0;
    }

    public static boolean elt(BigDecimal source, BigDecimal target) {
        return source.compareTo(target) <= 0;
    }

    @Deprecated
    public static Double scale(Double d, int scale) {
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        bigDecimal.setScale(scale);
        return bigDecimal.doubleValue();
    }
}

