/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.web.util;

import com.tcbj.framework.web.util.HttpTimeountConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class DynamicTimeoutInterceptor
implements Interceptor {
    private Map<String, HttpTimeountConfig> configMap = new HashMap<String, HttpTimeountConfig>();

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String url = request.url().toString();
        if (this.configMap.containsKey(url)) {
            HttpTimeountConfig config = this.configMap.get(url);
            return chain.withConnectTimeout(config.getConnectionTimeout(), TimeUnit.SECONDS).withReadTimeout(config.getReadTimeout(), TimeUnit.SECONDS).withWriteTimeout(config.getWriteTimeout(), TimeUnit.SECONDS).proceed(request);
        }
        return chain.proceed(request);
    }

    public void addTimeoutConfig(HttpTimeountConfig ... configs) {
        for (HttpTimeountConfig config : configs) {
            this.configMap.put(config.getUrl(), config);
        }
    }
}

