/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.web.util;

import com.tcbj.framework.dto.util.Jsons;
import com.tcbj.framework.web.util.DynamicTimeoutInterceptor;
import com.tcbj.framework.web.util.HttpTimeountConfig;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Https {
    private static volatile Https instance;
    private OkHttpClient client;
    private DynamicTimeoutInterceptor interceptor;

    private Https() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(10L, TimeUnit.SECONDS);
        builder.writeTimeout(10L, TimeUnit.SECONDS);
        builder.readTimeout(30L, TimeUnit.SECONDS);
        this.interceptor = new DynamicTimeoutInterceptor();
        builder.addInterceptor((Interceptor)this.interceptor);
        this.client = builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Https getInstance() {
        if (instance != null) return instance;
        Class<Https> clazz = Https.class;
        synchronized (Https.class) {
            if (instance != null) return instance;
            instance = new Https();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addHttpTimeoutConfig(HttpTimeountConfig ... configs) {
        this.interceptor.addTimeoutConfig(configs);
    }

    public void get(String url, Map<String, String> headers, Callback callback) {
        Request request = this.getRequestBuilder(headers).url(url).build();
        this.client.newCall(request).enqueue(callback);
    }

    public void post(String url, Map<String, String> headers, Object data, Callback callback) {
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        String jsonData = Jsons.toJson((Object)data);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)jsonData);
        Request request = this.getRequestBuilder(headers).url(url).post(body).build();
        this.client.newCall(request).enqueue(callback);
    }

    public void postFile(String url, Map<String, String> headers, File file, Callback callback) {
        MediaType MEDIA_TYPE = MediaType.parse((String)"multipart/form-data");
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MEDIA_TYPE, (File)file)).build();
        Request request = this.getRequestBuilder(headers).url(url).post((RequestBody)requestBody).build();
        this.client.newCall(request).enqueue(callback);
    }

    public String getSync(String url, Map<String, String> headers) {
        Request request = this.getRequestBuilder(headers).url(url).build();
        try {
            Response response = this.client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String postSync(String url, Map<String, String> headers, Object data) {
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        String jsonData = Jsons.toJson((Object)data);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)jsonData);
        Request request = this.getRequestBuilder(headers).url(url).post(body).build();
        try {
            Response response = this.client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String postFile(String url, Map<String, String> headers, File file) {
        MediaType MEDIA_TYPE = MediaType.parse((String)"multipart/form-data");
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MEDIA_TYPE, (File)file)).build();
        Request request = this.getRequestBuilder(headers).url(url).post((RequestBody)requestBody).build();
        try {
            Response response = this.client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Request.Builder getRequestBuilder(Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        if (headers != null && headers.size() > 0) {
            headers.forEach((k, v) -> builder.addHeader(k, v));
        }
        return builder;
    }
}

