/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.web.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;

public final class Jsons {
    private static JsonFactory jsonFactory = new JsonFactory();
    private static ObjectMapper mapper = null;

    private Jsons() {
    }

    public static <T> T toBean(String json, Class clazz) {
        Object rtv = null;
        try {
            rtv = mapper.readValue(json, clazz);
        }
        catch (Exception ex) {
            String cause = String.format("json to bean error:[%s],json:[%s]", ex.getMessage(), json);
            throw new IllegalArgumentException(cause, ex);
        }
        return (T)rtv;
    }

    public static <T> T toBean(InputStream in, Class clazz) {
        Object rtv = null;
        try {
            rtv = mapper.readValue(in, clazz);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("json-stream to bean error", ex);
        }
        return (T)rtv;
    }

    public static String toJson(Object bean) {
        String rtv = null;
        try {
            rtv = mapper.writeValueAsString(bean);
        }
        catch (Exception ex) {
            String cause = String.format("bean to json error:[%s],bean-class:[%s]", ex.getMessage(), bean.getClass());
            throw new IllegalArgumentException(cause, ex);
        }
        return rtv;
    }

    public static <T> List<T> toListBean(String json, Class<T> clazz) {
        List result = null;
        try {
            result = (List)mapper.readValue(json, Jsons.getCollectionType(List.class, clazz));
        }
        catch (Exception ex) {
            String cause = String.format("json to bean error:[%s],json:[%s]", ex.getMessage(), json);
            throw new IllegalArgumentException(cause, ex);
        }
        return result;
    }

    private static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    static {
        jsonFactory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        jsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper = new ObjectMapper(jsonFactory);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

