/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.web.converter;

import java.beans.PropertyEditorSupport;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.util.StringUtils;

public class DateConverterEditor
extends PropertyEditorSupport {
    private static final List<String> formarts = new ArrayList<String>(4);
    private static final String YYYY_MM = "yyyy-MM";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    static {
        formarts.add(YYYY_MM);
        formarts.add(YYYY_MM_DD);
        formarts.add(YYYY_MM_DD_HH_MM);
        formarts.add(YYYY_MM_DD_HH_MM_SS);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty((Object)text)) {
            this.setValue(null);
            return;
        }
        if ((text = text.trim()).matches("^\\d{4}-\\d{1,2}$")) {
            this.setValue(this.parseDate(text, formarts.get(0)));
        } else if (text.matches("^\\d{4}-\\d{1,2}-\\d{1,2}$")) {
            this.setValue(this.parseDate(text, formarts.get(1)));
        } else if (text.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")) {
            this.setValue(this.parseDate(text, formarts.get(2)));
        } else if (text.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$")) {
            this.setValue(this.parseDate(text, formarts.get(3)));
        } else {
            throw new IllegalArgumentException("Invalid false value '" + text + "'");
        }
    }

    private Date parseDate(String dateStr, String format) {
        Date date;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            date = dateFormat.parse(dateStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        return date;
    }

    @Override
    public String getAsText() {
        if (this.getValue() == null) {
            return null;
        }
        return this.getValue().toString();
    }
}

