/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.web.util;

import com.tcbj.framework.web.util.HttpTimeountConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class DynamicTimeoutInterceptor
implements Interceptor {
    private static Map<String, HttpTimeountConfig> configMap = new HashMap<String, HttpTimeountConfig>();
    private static final Pattern URL_PATTERN = Pattern.compile("^(https?)://([^/:]+)(:([^/]*))?(/.*)?$");

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String path = this.getPath(request.url().toString());
        if (configMap.containsKey(path)) {
            HttpTimeountConfig config = configMap.get(path);
            return chain.withConnectTimeout(config.getConnectionTimeout(), TimeUnit.SECONDS).withReadTimeout(config.getReadTimeout(), TimeUnit.SECONDS).withWriteTimeout(config.getWriteTimeout(), TimeUnit.SECONDS).proceed(request);
        }
        return chain.proceed(request);
    }

    public static void addTimeoutConfig(HttpTimeountConfig ... configs) {
        HttpTimeountConfig[] httpTimeountConfigArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            HttpTimeountConfig config = httpTimeountConfigArray[n2];
            configMap.put(config.getUrl(), config);
            ++n2;
        }
    }

    private String getPath(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.matches()) {
            String path = matcher.group(5);
            if (path != null) {
                return path;
            }
            return "";
        }
        return "";
    }
}

