/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.basedata.api.rpc;

import com.tcbj.framework.dto.Page;
import com.tcbj.framework.dto.Response;
import com.tcbj.tangsales.basedata.api.dto.request.DistribuQuery;
import com.tcbj.tangsales.basedata.api.dto.request.ProductQuery;
import com.tcbj.tangsales.basedata.api.dto.response.order.OrderProduct;
import com.tcbj.tangsales.basedata.api.dto.response.product.ProductDTO;
import com.tcbj.tangsales.basedata.api.dto.response.product.ProductLabelDTO;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name="tang-sales-basedata-module-service", path="/api/basedata/product")
public interface ProductApi {
    @GetMapping(value={"/{id}"})
    public Response<ProductDTO> getFullProductInfo(@PathVariable(value="id") String var1);

    @PostMapping(value={"/list"})
    public Response<List<ProductDTO>> getFullProductList(@RequestBody ProductQuery var1);

    @PostMapping(value={"/simple/{id}"})
    public Response<ProductDTO> getSimpleProductInfo(@PathVariable(value="id") String var1);

    @PostMapping(value={"/simple/list"})
    public Response<List<ProductDTO>> getSimpleProductList(@RequestBody ProductQuery var1);

    @GetMapping(value={"/cache/{id}"})
    public Response<ProductDTO> getFullProductInfoCache(@PathVariable(value="id") String var1);

    @PostMapping(value={"/simple/cache/{id}"})
    public Response<ProductDTO> getSimpleProductInfoCache(@PathVariable(value="id") String var1);

    @PostMapping(value={"/distribu"})
    public Response<List<OrderProduct>> getDistribuProduct(@RequestBody DistribuQuery var1);

    @GetMapping(value={"/maxLimits/{id}"})
    public Response<Map<String, Double>> getDistribuProductMaxLimits(@PathVariable(value="id") String var1);

    @PostMapping(value={"/getLabel"})
    public Response<List<ProductLabelDTO>> getLabel(@PathVariable(value="type") String var1);

    @PostMapping(value={"/getListPage"})
    public Response<Page<ProductDTO>> getListPage(@RequestBody ProductQuery var1);
}

