/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.basedata.api.rpc;

import com.tcbj.framework.dto.Response;
import com.tcbj.tangsales.basedata.api.contract.request.PartnerAddressQuery;
import com.tcbj.tangsales.basedata.api.contract.request.PartnerQuery;
import com.tcbj.tangsales.basedata.api.contract.response.partner.PartnerAddressDto;
import com.tcbj.tangsales.basedata.api.contract.response.partner.PartnerDto;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="tang-sales-basedata-module-service", path="/api/basedata/partner")
public interface PartnerApi {
    @GetMapping(value={"/{id}"})
    public Response<PartnerDto> getFullPartnerInfo(@PathVariable(value="id") String var1);

    @PostMapping(value={"/list"})
    public Response<List<PartnerDto>> getFullPartnerList(@RequestBody PartnerQuery var1);

    @PostMapping(value={"/simple/{id}"})
    public Response<PartnerDto> getSimplePartnerInfo(@PathVariable(value="id") String var1);

    @PostMapping(value={"/simple/list"})
    public Response<List<PartnerDto>> getSimplePartnerList(@RequestBody PartnerQuery var1);

    @GetMapping(value={"/cache/{id}"})
    public Response<PartnerDto> getFullPartnerInfoCache(@PathVariable(value="id") String var1);

    @PostMapping(value={"/cache/simple/{id}"})
    public Response<PartnerDto> getSimplePartnerInfoCache(@PathVariable(value="id") String var1);

    @PostMapping(value={"/address"})
    public Response<List<PartnerAddressDto>> getPartnerAddresssList(@RequestBody PartnerAddressQuery var1);

    @GetMapping(value={"/address/{addressId}"})
    public Response<PartnerAddressDto> getPartnerAddress(@PathVariable(value="addressId") String var1);

    @PostMapping(value={"/isBigCustomerOrKa"})
    public Response<Boolean> isBigCustomerOrKa(@RequestParam(name="partnerId") String var1);

    @PostMapping(value={"/getRelatePartners"})
    public Response<List<PartnerDto>> getRelatePartners(@RequestParam(name="partnerId") String var1);
}

