/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.basedata.api.rpc;

import com.tcbj.framework.dto.Page;
import com.tcbj.framework.dto.Response;
import com.tcbj.tangsales.basedata.api.contract.request.DistributorDealerBindingQuery;
import com.tcbj.tangsales.basedata.api.contract.request.DistributorQuery;
import com.tcbj.tangsales.basedata.api.contract.response.distributor.DistributorDealerBindingDto;
import com.tcbj.tangsales.basedata.api.contract.response.distributor.DistributorDto;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="tang-sales-basedata", path="/distributor")
public interface DistributorApi {
    @GetMapping(value={"/getById"})
    public Response<DistributorDto> getById(@RequestParam(name="id") String var1);

    @GetMapping(value={"/getByDistributorNo"})
    public Response<DistributorDto> getByDistributorNo(@RequestParam(name="distributorNo") String var1);

    @PostMapping(value={"/list"})
    public Response<List<DistributorDto>> list(@RequestBody DistributorQuery var1);

    @PostMapping(value={"/simpleList"})
    public Response<List<DistributorDto>> simpleList(@RequestBody DistributorQuery var1);

    @PostMapping(value={"/page"})
    public Response<Page<DistributorDto>> page(@RequestBody DistributorQuery var1);

    @PostMapping(value={"/save"})
    public Response<String> save(@RequestBody DistributorDto var1);

    @PostMapping(value={"/update"})
    public Response<Boolean> update(@RequestBody DistributorDto var1);

    @PostMapping(value={"/delete"})
    public Response<Boolean> delete(@RequestParam(name="id") String var1);

    @PostMapping(value={"/bindDealer"})
    public Response<String> bindDealer(@RequestBody DistributorDealerBindingDto var1);

    @PostMapping(value={"/batchBindDealer"})
    public Response<Boolean> batchBindDealer(@RequestBody List<DistributorDealerBindingDto> var1);

    @PostMapping(value={"/unbindDealer"})
    public Response<Boolean> unbindDealer(@RequestParam(name="distributorId") String var1, @RequestParam(name="dealerId") String var2, @RequestParam(name="supplierId") String var3);

    @PostMapping(value={"/getDealersByDistributorId"})
    public Response<List<DistributorDealerBindingDto>> getDealersByDistributorId(@RequestParam(name="distributorId") String var1, @RequestParam(name="supplierId") String var2, @RequestParam(name="onlyEffective", required=false) Boolean var3);

    @PostMapping(value={"/getDistributorsByDealerId"})
    public Response<List<DistributorDealerBindingDto>> getDistributorsByDealerId(@RequestParam(name="dealerId") String var1, @RequestParam(name="supplierId") String var2, @RequestParam(name="onlyEffective", required=false) Boolean var3);

    @PostMapping(value={"/listBindings"})
    public Response<List<DistributorDealerBindingDto>> listBindings(@RequestBody DistributorDealerBindingQuery var1);

    @PostMapping(value={"/checkBinding"})
    public Response<Boolean> checkBinding(@RequestParam(name="distributorId") String var1, @RequestParam(name="dealerId") String var2, @RequestParam(name="supplierId") String var3);
}

