/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.common.auth;

import com.tcbj.framework.dto.Operator;
import com.tcbj.framework.dto.Response;
import com.tcbj.framework.exception.exception.Thrower;
import com.tcbj.tangsales.auth.api.contract.request.UserResourceQuery;
import com.tcbj.tangsales.auth.api.rpc.AuthorizationApi;
import com.tcbj.tangsales.common.auth.Auth;
import com.tcbj.tangsales.common.operator.OperatorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AuthInterceptor
extends HandlerInterceptorAdapter {
    private static Logger logger = LoggerFactory.getLogger(AuthInterceptor.class);
    private AuthorizationApi authorizationApi;

    public AuthInterceptor(AuthorizationApi authorizationApi) {
        logger.debug("\u521d\u59cb\u5316\u63a5\u53e3\u6743\u9650\u6821\u9a8c\u62e6\u622a\u5668");
        this.authorizationApi = authorizationApi;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.handlePermission(request, handler);
        return true;
    }

    private void handlePermission(HttpServletRequest request, Object handler) {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Auth sessionAuth = handlerMethod.getMethod().getAnnotation(Auth.class);
            logger.debug("\u6821\u9a8c\u63a5\u53e3\u6743\u9650\uff0c\u63a5\u53e3\uff1a" + request.getRequestURI() + ",\u662f\u5426\u9700\u8981\u6821\u9a8c\u6743\u9650:" + (sessionAuth != null && sessionAuth.required() == Boolean.TRUE.booleanValue()));
            if (sessionAuth != null && sessionAuth.required() == Boolean.TRUE.booleanValue()) {
                String[] requireFunctions = sessionAuth.requireFunctions();
                List<String> userFuctions = this.getFunctions();
                this.checkPermission(requireFunctions, userFuctions);
            }
        }
    }

    private static String getParameter(HttpServletRequest request, String paramName) {
        String param = request.getParameter(paramName);
        if (StringUtils.isEmpty((Object)param)) {
            param = request.getHeader(paramName);
        }
        return param;
    }

    public List<String> getFunctions() {
        Operator operator = OperatorUtils.getOperator();
        UserResourceQuery query = new UserResourceQuery();
        query.setPersonId(operator.getPersonId());
        query.setOrgId(operator.getOrgId());
        Response fuctionsResp = this.authorizationApi.getUserResource(query);
        if (!fuctionsResp.isSuccess()) {
            Thrower.throwAppException((String)Response.StatusCode.AUTH_ERROR.getValue(), (String)"\u83b7\u53d6\u6743\u9650\u5931\u8d25");
        }
        return (List)fuctionsResp.getData();
    }

    private void checkPermission(String[] permissionCodes, List<String> userFunctions) {
        if (permissionCodes != null && permissionCodes.length > 0) {
            if (userFunctions != null && userFunctions.size() > 0) {
                ArrayList<String> codeList = new ArrayList<String>(Arrays.asList(permissionCodes));
                codeList.retainAll(userFunctions);
                if (codeList.size() == 0) {
                    Thrower.throwAppException((String)Response.StatusCode.ACCESS_DENIED.getValue(), (String)"Access Denied");
                }
            } else {
                Thrower.throwAppException((String)Response.StatusCode.ACCESS_DENIED.getValue(), (String)"Access Denied");
            }
        }
    }
}

