/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.common.operator;

import com.tcbj.framework.dto.Operator;
import com.tcbj.framework.dto.util.Jsons;
import com.tcbj.tangsales.common.operator.OperatorInterceptor;
import com.tcbj.tangsales.common.operator.OperatorUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class OperatorConfig
implements WebMvcConfigurer,
RequestInterceptor {
    @Autowired
    private OperatorInterceptor operatorInterceptor;

    public void apply(RequestTemplate template) {
        Operator operator;
        HttpServletRequest request;
        Enumeration headerNames;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        boolean headerContainOperator = false;
        if (attributes != null && (headerNames = (request = attributes.getRequest()).getHeaderNames()) != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                String values = request.getHeader(name);
                if (!name.equalsIgnoreCase("AUTH-OPERATOR")) continue;
                template.header(name, new String[]{values});
                headerContainOperator = true;
                break;
            }
        }
        if (!headerContainOperator && (operator = OperatorUtils.getOperator()) != null) {
            template.header("AUTH-OPERATOR", new String[]{Jsons.toJson((Object)operator)});
        }
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.operatorInterceptor).excludePathPatterns(new String[]{"/static/*"}).excludePathPatterns(new String[]{"/error"}).excludePathPatterns(new String[]{"/v2/api-docs", "/configuration/ui", "/configuration/security", "/swagger-resources/**", "/webjars/**", "/swagger-ui.html"}).addPathPatterns(new String[]{"/**"}).order(-1);
    }
}

