/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.common.operator;

import com.tcbj.framework.dto.Operator;
import com.tcbj.framework.dto.util.Jsons;
import com.tcbj.tangsales.common.operator.OperatorUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class OperatorConfig
implements RequestInterceptor {
    private static Logger logger = LoggerFactory.getLogger(OperatorConfig.class);

    public OperatorConfig() {
        logger.debug("\u521d\u59cb\u5316feign\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\u5934\u62e6\u622a\u5668");
    }

    public void apply(RequestTemplate template) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        boolean headerContainOperator = false;
        if (attributes != null) {
            logger.debug("\u4ece\u8bf7\u6c42\u5934\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
            HttpServletRequest request = attributes.getRequest();
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    String values = request.getHeader(name);
                    if (!name.equalsIgnoreCase("AUTH-OPERATOR")) continue;
                    template.header(name, new String[]{values});
                    headerContainOperator = true;
                    break;
                }
            }
            logger.debug("\u8bf7\u6c42\u5934\u662f\u5426\u5b58\u5728\u7528\u6237\u4fe1\u606f\uff1a" + headerContainOperator);
        }
        if (!headerContainOperator) {
            logger.debug("\u4ece\u5f53\u524d\u7ebf\u7a0b\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
            Operator operator = OperatorUtils.getOperator();
            logger.debug("\u5f53\u524d\u7ebf\u7a0b\u662f\u5426\u5b58\u5728\u7528\u6237\u4fe1\u606f\uff1a" + (operator != null));
            if (operator != null) {
                template.header("AUTH-OPERATOR", new String[]{Jsons.toJson((Object)operator)});
            }
        }
    }
}

