/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.ec.inventory.api.contract.constant;

import java.util.Arrays;
import java.util.List;
import org.springframework.util.StringUtils;

public enum AllotReturnOrderStatusEnum {
    DRAFT(0, "\u8349\u7a3f"),
    PENDING_AUDIT(1, "\u5f85\u5ba1\u6279"),
    AUDIT_PASSED(2, "\u5ba1\u6279\u901a\u8fc7"),
    AUDIT_REJECTED(3, "\u5ba1\u6279\u4e0d\u901a\u8fc7"),
    SHIPPING(4, "\u51fa\u5e93\u4e2d"),
    OUT_TERMINATED(5, "\u51fa\u5e93\u7ec8\u6b62"),
    RECEIVING(6, "\u5165\u5e93\u4e2d"),
    IN_TERMINATED(7, "\u5165\u5e93\u7ec8\u6b62"),
    SETTLING(8, "\u7ed3\u7b97\u4e2d"),
    COMPLETED(9, "\u5df2\u5b8c\u6210");

    private Integer code;
    private String name;
    public static List<Integer> ALLOW_CREATE_STATUS;
    public static List<Integer> ALLOW_EDIT_STATUS;
    public static List<Integer> SYNC_E3_STATUS;

    private AllotReturnOrderStatusEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static boolean isBeforeApproval(Integer code) {
        return AllotReturnOrderStatusEnum.DRAFT.code.equals(code) || AllotReturnOrderStatusEnum.PENDING_AUDIT.code.equals(code);
    }

    public static AllotReturnOrderStatusEnum getByCode(Integer code) {
        if (StringUtils.isEmpty((Object)code)) {
            return null;
        }
        return Arrays.stream(AllotReturnOrderStatusEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(null);
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static {
        ALLOW_CREATE_STATUS = Arrays.asList(AllotReturnOrderStatusEnum.DRAFT.code, AllotReturnOrderStatusEnum.PENDING_AUDIT.code);
        ALLOW_EDIT_STATUS = Arrays.asList(AllotReturnOrderStatusEnum.DRAFT.code, AllotReturnOrderStatusEnum.PENDING_AUDIT.code, AllotReturnOrderStatusEnum.AUDIT_REJECTED.code);
        SYNC_E3_STATUS = Arrays.asList(AllotReturnOrderStatusEnum.AUDIT_PASSED.code, AllotReturnOrderStatusEnum.SHIPPING.code, AllotReturnOrderStatusEnum.RECEIVING.code);
    }
}

