/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.order.api.contract.constant;

import java.util.Date;
import org.springframework.util.StringUtils;

public class DiscountEnum {

    public static enum StateType {
        noApprove("0", "\u5f85\u5ba1\u6279", false),
        passApprove("1", "\u5df2\u5ba1\u6279", false),
        invalid("2", "\u5df2\u4f5c\u5e9f", true),
        frozen("4", "\u5df2\u51bb\u7ed3", true),
        carried("5", "\u5df2\u8f6c\u7ed3", true),
        unknown("9", "XX", true);

        private final String type;
        private final String name;
        private final Boolean state;

        private StateType(String type, String name, Boolean state) {
            this.type = type;
            this.name = name;
            this.state = state;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public static String getNameByType(String type, Date endDate) {
            for (StateType types : StateType.values()) {
                if (types.state.booleanValue()) {
                    if (!types.getType().equals(type)) continue;
                    return types.getName();
                }
                if (endDate == null) {
                    if (types.getType().equals(type)) {
                        return types.getName();
                    }
                    if (!StringUtils.isEmpty((Object)type)) continue;
                    return StateType.passApprove.name;
                }
                if (endDate.getTime() < new Date().getTime()) {
                    return "\u5df2\u7ed3\u675f";
                }
                if (types.getType().equals(type)) {
                    return types.getName();
                }
                if (!StringUtils.isEmpty((Object)type)) continue;
                return StateType.passApprove.name;
            }
            return "XX";
        }
    }

    public static enum StatementType {
        USE(1, "\u4f7f\u7528"),
        CANCEL(2, "\u64a4\u9500");

        private final int type;
        private final String name;

        private StatementType(int type, String name) {
            this.type = type;
            this.name = name;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public static String getNameByType(int type) {
            for (StatementType types : StatementType.values()) {
                if (types.getType() != type) continue;
                return types.getName();
            }
            return null;
        }
    }

    public static enum FactorType {
        PRODUCT("PRODUCT", "\u4ea7\u54c1\u6298\u6263\u9650\u989d"),
        GIFT_MATERIAL("GIFT_MATERIAL", "\u8d60\u54c1\u7269\u6599\u6298\u6263\u9650\u989d");

        private final String factorType;
        private final String factorName;

        private FactorType(String factorType, String factorName) {
            this.factorType = factorType;
            this.factorName = factorName;
        }

        public String getFactorType() {
            return this.factorType;
        }

        public String getFactorName() {
            return this.factorName;
        }

        public static String getNameByType(String type) {
            for (FactorType types : FactorType.values()) {
                if (!types.getFactorType().equals(type)) continue;
                return types.getFactorName();
            }
            return null;
        }
    }
}

