/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.order.api.rpc;

import com.tcbj.framework.dto.Page;
import com.tcbj.framework.dto.Response;
import com.tcbj.tangsales.order.api.contract.request.AutoApproveSalesOrderCmd;
import com.tcbj.tangsales.order.api.contract.request.CspApproveOrderCmd;
import com.tcbj.tangsales.order.api.contract.request.SalesOrderQuery;
import com.tcbj.tangsales.order.api.contract.request.salesorder.ApprovalSalesOrderCmd;
import com.tcbj.tangsales.order.api.contract.request.salesorder.InitImportSalesOrderCmd;
import com.tcbj.tangsales.order.api.contract.request.salesorder.InitSalesOrderCmd;
import com.tcbj.tangsales.order.api.contract.response.NodeDto;
import com.tcbj.tangsales.order.api.contract.response.SalesOrderDto;
import com.tcbj.tangsales.order.api.contract.response.common.ApproveResultDto;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="tang-sales-order-module-service", path="/api/order")
public interface SalesOrderApi {
    @PostMapping(value={"/query"})
    public Response<Page<SalesOrderDto>> querySalesOrder(@RequestBody SalesOrderQuery var1);

    @PostMapping(value={"/list"})
    public Response<List<SalesOrderDto>> list(@RequestBody SalesOrderQuery var1);

    @PostMapping(value={"/get"})
    public Response<SalesOrderDto> getSalesOrder(@RequestParam(name="id") String var1);

    @PostMapping(value={"/getOrderItemExcel"})
    public Response<List<Map>> getSalesOrderItemExcel(@RequestBody SalesOrderQuery var1);

    @PostMapping(value={"/getOrderExcel"})
    public Response<List<Map>> getSalesOrderExcel(@RequestBody SalesOrderQuery var1);

    @PostMapping(value={"/exportSurveyReport"})
    public Response<List<Map<String, String>>> exportSurveyReport(@RequestBody SalesOrderQuery var1);

    @PostMapping(value={"/exportCustomerSurveyReports"})
    public Response<List<Map<String, String>>> exportCustomerSurveyReports(@RequestParam(name="carrierNo") String var1, @RequestParam(name="orderNo") String var2, @RequestParam(name="orgId") String var3);

    @PostMapping(value={"/getSimple"})
    public Response<SalesOrderDto> getSimpleSalesOrder(@RequestParam(name="id") String var1);

    @PostMapping(value={"/getSalesOrderCount"})
    public Response<List<NodeDto>> getSalesOrderCount(@RequestBody SalesOrderQuery var1);

    @PostMapping(value={"/saveOrder"})
    public Response<ApproveResultDto> saveOrder(@RequestBody ApprovalSalesOrderCmd var1);

    @PostMapping(value={"/copyOrder"})
    public Response<ApproveResultDto> copyOrder(@RequestBody ApprovalSalesOrderCmd var1);

    @PostMapping(value={"/approval"})
    public Response<ApproveResultDto> approval(@RequestBody ApprovalSalesOrderCmd var1);

    @PostMapping(value={"/initSalesOrder"})
    public Response<SalesOrderDto> initSalesOrder(@RequestBody InitSalesOrderCmd var1);

    @PostMapping(value={"/initImportSalesOrder"})
    public Response<ApproveResultDto> initImportSalesOrder(@RequestBody InitImportSalesOrderCmd var1);

    @PostMapping(value={"/validate"})
    public Response<ApproveResultDto> validate(@RequestBody ApprovalSalesOrderCmd var1);

    @PostMapping(value={"/autoApproveForJob"})
    public Response<ApproveResultDto> autoApproveForJob(@RequestBody AutoApproveSalesOrderCmd var1);

    @PostMapping(value={"/autoRejectForJob"})
    public Response<ApproveResultDto> autoRejectForJob(@RequestBody AutoApproveSalesOrderCmd var1);

    @PostMapping(value={"/pushOrderToSap"})
    public Response<ApproveResultDto> pushOrderToSap(@RequestBody CspApproveOrderCmd var1);

    @PostMapping(value={"/test"})
    public Response<ApproveResultDto> test(@RequestBody ApprovalSalesOrderCmd var1);

    @PostMapping(value={"/getOrderByNo"})
    public Response<SalesOrderDto> getOrderByNo(@RequestParam(name="no") String var1);
}

