/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.generate;

import com.google.common.base.CaseFormat;
import com.tcbj.framework.jdbc.core.Repository;
import com.tcbj.framework.jdbc.util.SimpleSqlQuery;
import com.tcbj.tangsales.generate.entity.ColumnInfo;
import com.tcbj.tangsales.generate.eo.Domain;
import com.tcbj.tangsales.generate.eo.Entity;
import com.tcbj.tangsales.generate.eo.PropsInfo;
import com.tcbj.tangsales.generate.eo.TableInfo;
import com.tcbj.tangsales.generate.util.FreemarkerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;

public class Generator {
    private Domain domain;
    private String templatePath = "tang-sales-util-generate" + File.separator + "src" + File.separator + "main" + File.separator + "java";
    private Repository repository;

    public Generator(Domain domain, Repository repository) {
        this.domain = domain;
        this.repository = repository;
    }

    public void generate() throws Exception {
        this.createDirectory();
        TableInfo aggregate = this.createEntity();
        this.createAssembler(aggregate);
        this.createRepository(aggregate);
        this.createService();
    }

    private void createAssembler(TableInfo aggregate) throws Exception {
        File file = new File(this.domain.getAssemblerFilePath() + File.separator + aggregate.getEntityName() + "Mapper.java");
        if (!file.exists()) {
            file.createNewFile();
        }
        FreemarkerUtil.generateFile("assembler.ftl", aggregate, file);
        if (!aggregate.getChildren().isEmpty()) {
            aggregate.getChildren().forEach(t -> {
                File f = new File(this.domain.getAssemblerFilePath() + File.separator + t.getEntityName() + "Mapper.java");
                try {
                    FreemarkerUtil.generateFile("assembler.ftl", t, f);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private void createRepository(TableInfo aggregate) throws Exception {
        File file = new File(this.domain.getRepositoryFilePath() + File.separator + aggregate.getEntityName() + "Repository.java");
        if (!file.exists()) {
            file.createNewFile();
        }
        FreemarkerUtil.generateFile("repository.ftl", aggregate, file);
        File interfaceFile = new File(this.domain.getRepositoryFilePath() + File.separator + aggregate.getEntityName() + "RepositoryImpl.java");
        if (!interfaceFile.exists()) {
            interfaceFile.createNewFile();
        }
        FreemarkerUtil.generateFile("repositoryImpl.ftl", aggregate, interfaceFile);
    }

    private void createService() {
    }

    private TableInfo createEntity() throws Exception {
        File file;
        Entity aggregate = this.domain.getAggregate();
        TableInfo tableInfo = this.turnTable(aggregate);
        if (aggregate.getChildEntity() != null && aggregate.getChildEntity().size() > 0) {
            aggregate.getChildEntity().forEach((r, e) -> {
                TableInfo child = this.turnTable((Entity)e);
                child.setRelation(r.split("\\.")[1]);
                tableInfo.getChildren().add(child);
            });
        }
        if (!(file = new File(this.domain.getEntityFilePath() + File.separator + aggregate.getEntityName() + ".java")).exists()) {
            file.createNewFile();
        }
        FreemarkerUtil.generateFile("entity.ftl", tableInfo, file);
        File dtoFile = new File(this.domain.getDtoFilePath() + File.separator + aggregate.getEntityName() + "DTO.java");
        if (!dtoFile.exists()) {
            dtoFile.createNewFile();
        }
        FreemarkerUtil.generateFile("DTO.ftl", tableInfo, dtoFile);
        if (!tableInfo.getChildren().isEmpty()) {
            tableInfo.getChildren().forEach(t -> {
                File f = new File(this.domain.getEntityFilePath() + File.separator + t.getEntityName() + ".java");
                File fc = new File(this.domain.getDtoFilePath() + File.separator + t.getEntityName() + "DTO.java");
                try {
                    FreemarkerUtil.generateFile("entity.ftl", t, f);
                    FreemarkerUtil.generateFile("DTO.ftl", t, fc);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return tableInfo;
    }

    private TableInfo turnTable(Entity entity) {
        List<ColumnInfo> columnInfos = this.getColumns(entity);
        TableInfo tableInfo = new TableInfo();
        tableInfo.setTableName(entity.getTableName());
        tableInfo.setEntityName(entity.getEntityName());
        tableInfo.setPackagePath(this.domain.getPackagePath());
        tableInfo.setIdColumnName(entity.getIdColumnName());
        List<String> columns = entity.getExcludeColumns();
        for (ColumnInfo col : columnInfos) {
            if (columns.contains(col.getColumnName().toLowerCase())) continue;
            PropsInfo propsInfo = new PropsInfo();
            propsInfo.setPkFlag(col.getColumnName().toUpperCase(Locale.ROOT).equals(tableInfo.getIdColumnName().toUpperCase(Locale.ROOT)) ? "Y" : "N");
            propsInfo.setPropName(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, col.getColumnName().toLowerCase(Locale.ROOT)));
            propsInfo.setColumnName(col.getColumnName());
            if ("DATE".equals(col.getDataType())) {
                propsInfo.setType("Date");
                tableInfo.setImportDate(true);
            } else if ("NUMBER".equals(col.getDataType())) {
                propsInfo.setType("BigDecimal");
                tableInfo.setImportBigDeimal(true);
            } else {
                propsInfo.setType("String ");
            }
            tableInfo.getPropsInfo().add(propsInfo);
        }
        return tableInfo;
    }

    private List<ColumnInfo> getColumns(Entity entity) {
        SimpleSqlQuery query = new SimpleSqlQuery(this.repository, ColumnInfo.class);
        query.appendSql("select DISTINCT * from ( SELECT  column_name, data_type, data_length, nullable,column_id  FROM all_tab_columns WHERE table_name = ? ) order by column_id", new Object[]{entity.getTableName().toUpperCase()});
        List columnInfos = query.list();
        if (columnInfos == null || columnInfos.isEmpty()) {
            throw new RuntimeException("can not find any columns in table :" + entity.getTableName());
        }
        return columnInfos;
    }

    private void createDirectory() throws Exception {
        if (Files.notExists(Paths.get(this.domain.getDtoFilePath(), new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(this.domain.getDtoFilePath(), new String[0]), new FileAttribute[0]);
        }
        if (Files.notExists(Paths.get(this.domain.getAssemblerFilePath(), new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(this.domain.getAssemblerFilePath(), new String[0]), new FileAttribute[0]);
        }
        if (Files.notExists(Paths.get(this.domain.getEntityFilePath(), new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(this.domain.getEntityFilePath(), new String[0]), new FileAttribute[0]);
        }
        if (Files.notExists(Paths.get(this.domain.getRepositoryFilePath(), new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(this.domain.getRepositoryFilePath(), new String[0]), new FileAttribute[0]);
        }
        if (Files.notExists(Paths.get(this.domain.getServiceFilePath(), new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(this.domain.getServiceFilePath(), new String[0]), new FileAttribute[0]);
        }
    }
}

