/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.generate.eo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Entity {
    private String tableName;
    private String idColumnName;
    private String entityName;
    private List<String> excludeColumns = new ArrayList<String>();
    private Map<String, Entity> childEntity = new HashMap<String, Entity>();

    public Entity(String tableName, String idColumnName, String entityName) {
        this.tableName = tableName;
        this.idColumnName = idColumnName;
        this.entityName = entityName;
    }

    public Entity(String tableName, String idColumnName, String entityName, List<String> excludeColumns) {
        this.tableName = tableName;
        this.idColumnName = idColumnName;
        this.entityName = entityName;
        this.excludeColumns = excludeColumns.stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    public Entity addChild(Entity entity, String relation) {
        this.childEntity.put(entity.getTableName() + "." + relation, entity);
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getIdColumnName() {
        return this.idColumnName;
    }

    public void setIdColumnName(String idColumnName) {
        this.idColumnName = idColumnName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public Map<String, Entity> getChildEntity() {
        return this.childEntity;
    }

    public List<String> getExcludeColumns() {
        return this.excludeColumns;
    }

    public void setExcludeColumns(List<String> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }
}

