/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.generate.util;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;

public class FreemarkerUtil {
    public static Configuration cfg = new Configuration();

    public static String generateString(String fileName, Object data) throws IOException {
        StringWriter out = new StringWriter();
        FreemarkerUtil.process(fileName, data, out);
        return out.getBuffer().toString();
    }

    public static void generateFile(String fileName, Object data, File outFile) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "utf-8"));
        FreemarkerUtil.process(fileName, data, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void process(String fileName, Object data, Writer out) throws IOException {
        try {
            Template template = FreemarkerUtil.getTemplate(fileName);
            template.process(data, out);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static Template getTemplate(String fileName) {
        try {
            Template temp = cfg.getTemplate(fileName);
            return temp;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        cfg.setEncoding(Locale.CHINA, "utf-8");
        cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(FreemarkerUtil.class, "/templates/"));
    }
}

