/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.order.domain.discount.repository;

import com.tcbj.framework.jdbc.core.Repository;
import com.tcbj.framework.jdbc.util.SimpleSqlQuery;
import com.tcbj.tangsales.order.domain.discount.entity.Discount;
import com.tcbj.tangsales.order.domain.discount.entity.DiscountStatement;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DiscountRepository {
    @Autowired
    private Repository repository;

    public Discount getDiscount(String id) {
        Discount discount = (Discount)this.repository.selectById((Serializable)((Object)id), Discount.class);
        if (discount != null) {
            discount.setDiscountStatements(this.getDiscountStatements(id));
        }
        return discount;
    }

    public List<DiscountStatement> getDiscountStatements(String aggregateId) {
        SimpleSqlQuery query = new SimpleSqlQuery(this.repository, DiscountStatement.class);
        query.appendSql(" SELECT *  FROM cx_int_rebate where rebate_id = ? ", new Object[]{aggregateId});
        List list = query.list();
        return list;
    }

    public String save(Discount discount) {
        this.repository.saveEntity((Object)discount);
        String id = discount.getId();
        if (discount.getDiscountStatements() != null && discount.getDiscountStatements().size() > 0) {
            discount.getDiscountStatements().forEach(e -> e.setRebateId(id));
            this.repository.batchSaveEntity(discount.getDiscountStatements());
        }
        return id;
    }

    public void update(Discount discount) {
        this.repository.updateEntity((Object)discount);
        if (discount.getDiscountStatements() != null && discount.getDiscountStatements().size() > 0) {
            this.repository.batchUpdateEntity(discount.getDiscountStatements());
        }
    }
}

