/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.order.domain.discounttype.repository;

import com.tcbj.framework.jdbc.core.Repository;
import com.tcbj.framework.jdbc.util.SimpleSqlQuery;
import com.tcbj.tangsales.order.domain.discounttype.entity.DiscountType;
import com.tcbj.tangsales.order.domain.discounttype.entity.DisctTypeAutoMapBrand;
import com.tcbj.tangsales.order.domain.discounttype.entity.DisctTypeAutoMapBudget;
import com.tcbj.tangsales.order.domain.discounttype.entity.DisctTypeRangeBrand;
import com.tcbj.tangsales.order.domain.discounttype.entity.DisctTypeRangeProd;
import com.tcbj.tangsales.order.domain.discounttype.entity.DisctTypeRangeSubtype;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DiscountTypeRepository {
    @Autowired
    private Repository repository;

    public DiscountType getDiscountType(String id) {
        DiscountType discountType = (DiscountType)this.repository.selectById((Serializable)((Object)id), DiscountType.class);
        if (discountType != null) {
            discountType.setDisctTypeAutoMapBrands(this.getDisctTypeAutoMapBrands(id));
            discountType.setDisctTypeRangeBrands(this.getDisctTypeRangeBrands(id));
            discountType.setDisctTypeRangeSubtypes(this.getDisctTypeRangeSubtypes(id));
            discountType.setDisctTypeAutoMapBudgets(this.getDisctTypeAutoMapBudgets(id));
            discountType.setDisctTypeRangeProds(this.getDisctTypeRangeProds(id));
        }
        return discountType;
    }

    public List<DisctTypeAutoMapBrand> getDisctTypeAutoMapBrands(String aggregateId) {
        SimpleSqlQuery query = new SimpleSqlQuery(this.repository, DisctTypeAutoMapBrand.class);
        query.appendSql(" SELECT *  FROM cx_disct_type_auto_map_brand where discount_type_id = ? ", new Object[]{aggregateId});
        List list = query.list();
        return list;
    }

    public List<DisctTypeRangeBrand> getDisctTypeRangeBrands(String aggregateId) {
        SimpleSqlQuery query = new SimpleSqlQuery(this.repository, DisctTypeRangeBrand.class);
        query.appendSql(" SELECT *  FROM cx_disct_type_range_brand where discount_type_id = ? ", new Object[]{aggregateId});
        List list = query.list();
        return list;
    }

    public List<DisctTypeRangeSubtype> getDisctTypeRangeSubtypes(String aggregateId) {
        SimpleSqlQuery query = new SimpleSqlQuery(this.repository, DisctTypeRangeSubtype.class);
        query.appendSql(" SELECT *  FROM cx_disct_type_range_subtype where discount_type_id = ? ", new Object[]{aggregateId});
        List list = query.list();
        return list;
    }

    public List<DisctTypeAutoMapBudget> getDisctTypeAutoMapBudgets(String aggregateId) {
        SimpleSqlQuery query = new SimpleSqlQuery(this.repository, DisctTypeAutoMapBudget.class);
        query.appendSql(" SELECT *  FROM cx_disct_type_auto_map_budget where discount_type_id = ? ", new Object[]{aggregateId});
        List list = query.list();
        return list;
    }

    public List<DisctTypeRangeProd> getDisctTypeRangeProds(String aggregateId) {
        SimpleSqlQuery query = new SimpleSqlQuery(this.repository, DisctTypeRangeProd.class);
        query.appendSql(" SELECT *  FROM cx_disct_type_range_prod where discount_type_id = ? ", new Object[]{aggregateId});
        List list = query.list();
        return list;
    }

    public String save(DiscountType discountType) {
        this.repository.saveEntity((Object)discountType);
        String id = discountType.getId();
        if (discountType.getDisctTypeAutoMapBrands() != null && discountType.getDisctTypeAutoMapBrands().size() > 0) {
            discountType.getDisctTypeAutoMapBrands().forEach(e -> e.setDiscountTypeId(id));
            this.repository.batchSaveEntity(discountType.getDisctTypeAutoMapBrands());
        }
        if (discountType.getDisctTypeRangeBrands() != null && discountType.getDisctTypeRangeBrands().size() > 0) {
            discountType.getDisctTypeRangeBrands().forEach(e -> e.setDiscountTypeId(id));
            this.repository.batchSaveEntity(discountType.getDisctTypeRangeBrands());
        }
        if (discountType.getDisctTypeRangeSubtypes() != null && discountType.getDisctTypeRangeSubtypes().size() > 0) {
            discountType.getDisctTypeRangeSubtypes().forEach(e -> e.setDiscountTypeId(id));
            this.repository.batchSaveEntity(discountType.getDisctTypeRangeSubtypes());
        }
        if (discountType.getDisctTypeAutoMapBudgets() != null && discountType.getDisctTypeAutoMapBudgets().size() > 0) {
            discountType.getDisctTypeAutoMapBudgets().forEach(e -> e.setDiscountTypeId(id));
            this.repository.batchSaveEntity(discountType.getDisctTypeAutoMapBudgets());
        }
        if (discountType.getDisctTypeRangeProds() != null && discountType.getDisctTypeRangeProds().size() > 0) {
            discountType.getDisctTypeRangeProds().forEach(e -> e.setDiscountTypeId(id));
            this.repository.batchSaveEntity(discountType.getDisctTypeRangeProds());
        }
        return id;
    }

    public void update(DiscountType discountType) {
        this.repository.updateEntity((Object)discountType);
        if (discountType.getDisctTypeAutoMapBrands() != null && discountType.getDisctTypeAutoMapBrands().size() > 0) {
            this.repository.batchUpdateEntity(discountType.getDisctTypeAutoMapBrands());
        }
        if (discountType.getDisctTypeRangeBrands() != null && discountType.getDisctTypeRangeBrands().size() > 0) {
            this.repository.batchUpdateEntity(discountType.getDisctTypeRangeBrands());
        }
        if (discountType.getDisctTypeRangeSubtypes() != null && discountType.getDisctTypeRangeSubtypes().size() > 0) {
            this.repository.batchUpdateEntity(discountType.getDisctTypeRangeSubtypes());
        }
        if (discountType.getDisctTypeAutoMapBudgets() != null && discountType.getDisctTypeAutoMapBudgets().size() > 0) {
            this.repository.batchUpdateEntity(discountType.getDisctTypeAutoMapBudgets());
        }
        if (discountType.getDisctTypeRangeProds() != null && discountType.getDisctTypeRangeProds().size() > 0) {
            this.repository.batchUpdateEntity(discountType.getDisctTypeRangeProds());
        }
    }
}

