/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.order.domain.salesorder.repository;

import com.tcbj.framework.jdbc.core.Repository;
import com.tcbj.framework.jdbc.util.SimpleSqlQuery;
import com.tcbj.tangsales.order.domain.salesorder.entity.SalesOrder;
import com.tcbj.tangsales.order.domain.salesorder.entity.SalesOrderDiscountUsage;
import com.tcbj.tangsales.order.domain.salesorder.entity.SalesOrderItem;
import com.tcbj.tangsales.order.domain.salesorder.repository.SalesOrderRepository;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SalesOrderRepositoryImpl
implements SalesOrderRepository {
    @Autowired
    private Repository repository;

    @Override
    public SalesOrder getSalesOrder(String id) {
        SalesOrder salesOrder = (SalesOrder)this.repository.selectById((Serializable)((Object)id), SalesOrder.class);
        if (salesOrder != null) {
            salesOrder.setSalesOrderDiscountUsages(this.getSalesOrderDiscountUsages(id));
            salesOrder.setSalesOrderItems(this.getSalesOrderItems(id));
        }
        return salesOrder;
    }

    @Override
    public List<SalesOrderDiscountUsage> getSalesOrderDiscountUsages(String aggregateId) {
        SimpleSqlQuery query = new SimpleSqlQuery(this.repository, SalesOrderDiscountUsage.class);
        query.appendSql(" SELECT *  FROM CX_BILL_DISCOUNT_USAGE where BILL_ID = ? ", new Object[]{aggregateId});
        List list = query.list();
        return list;
    }

    @Override
    public List<SalesOrderItem> getSalesOrderItems(String aggregateId) {
        SimpleSqlQuery query = new SimpleSqlQuery(this.repository, SalesOrderItem.class);
        query.appendSql(" SELECT *  FROM cx_indent_line where INDENT_APPLY_ID = ? ", new Object[]{aggregateId});
        List list = query.list();
        return list;
    }

    @Override
    public String save(SalesOrder salesOrder) {
        this.repository.saveEntity((Object)salesOrder);
        String id = salesOrder.getId();
        if (salesOrder.getSalesOrderDiscountUsages() != null && salesOrder.getSalesOrderDiscountUsages().size() > 0) {
            salesOrder.getSalesOrderDiscountUsages().forEach(e -> e.setBillId(id));
            this.repository.batchSaveEntity(salesOrder.getSalesOrderDiscountUsages());
        }
        if (salesOrder.getSalesOrderItems() != null && salesOrder.getSalesOrderItems().size() > 0) {
            salesOrder.getSalesOrderItems().forEach(e -> e.setIndentApplyId(id));
            this.repository.batchSaveEntity(salesOrder.getSalesOrderItems());
        }
        return id;
    }

    @Override
    public void update(SalesOrder salesOrder) {
        this.repository.updateEntity((Object)salesOrder);
        if (salesOrder.getSalesOrderDiscountUsages() != null && salesOrder.getSalesOrderDiscountUsages().size() > 0) {
            this.repository.batchUpdateEntity(salesOrder.getSalesOrderDiscountUsages());
        }
        if (salesOrder.getSalesOrderItems() != null && salesOrder.getSalesOrderItems().size() > 0) {
            this.repository.batchUpdateEntity(salesOrder.getSalesOrderItems());
        }
    }
}

