package ${packagePath}.repository;


import com.tcbj.framework.jdbc.core.Repository;
import com.tcbj.framework.jdbc.util.SimpleSqlQuery;
import ${packagePath}.entity.${entityName};
import ${packagePath}.repository.${entityName}Repository;
<#if children?size gt 0>
<#list children as child>
import ${packagePath}.entity.${child.entityName};
</#list>
</#if>
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class ${entityName}RepositoryImpl implements ${entityName}Repository {

    @Autowired
    private Repository repository;

    @Override
    public ${entityName} get${entityName}(String id){
        ${entityName} ${entityName?uncap_first} = repository.selectById(id,${entityName}.class);
<#if children?size gt 0>
        if(${entityName?uncap_first} != null){

    <#list children as child>
            ${entityName?uncap_first}.set${child.entityName}s(get${child.entityName}s(id));
    </#list>

        }
</#if>
        return ${entityName?uncap_first};
    }

    <#if children?size gt 0>
    <#list children as child>
    @Override
    public List<${child.entityName}> get${child.entityName}s(String aggregateId){
        SimpleSqlQuery<${child.entityName}> query = new SimpleSqlQuery<>(repository,${child.entityName}.class);
        query.appendSql(" SELECT *  FROM ${child.tableName} where ${child.relation} = ? ",aggregateId);
        List<${child.entityName}> list = query.list();
        return list;
    }

    </#list>
    </#if>
    @Override
    public String save(${entityName} ${entityName?uncap_first}){
        repository.saveEntity(${entityName?uncap_first});
        String id = ${entityName?uncap_first}.getId();
<#if children?size gt 0>
    <#list children as child>
        if(${entityName?uncap_first}.get${child.entityName}s() != null && ${entityName?uncap_first}.get${child.entityName}s().size() >0){
            ${entityName?uncap_first}.get${child.entityName}s().forEach(e->{
                e.set${child.relationProp?cap_first}(id);
            });
            repository.batchSaveEntity(${entityName?uncap_first}.get${child.entityName}s());
        }
    </#list>
</#if>
        return id;
    }

    @Override
    public void update(${entityName} ${entityName?uncap_first}){
        repository.updateEntity(${entityName?uncap_first});
<#if children?size gt 0>
    <#list children as child>
        if(${entityName?uncap_first}.get${child.entityName}s() != null && ${entityName?uncap_first}.get${child.entityName}s().size() >0){
            repository.batchUpdateEntity(${entityName?uncap_first}.get${child.entityName}s());
        }
    </#list>
</#if>
    }

}
