/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.basedata.domain.person.assembler;

import com.tcbj.tangsales.basedata.domain.person.assembler.PersonMapper;
import com.tcbj.tangsales.basedata.domain.person.assembler.RoleCMapper;
import com.tcbj.tangsales.basedata.domain.person.assembler.StaffDealerMapper;
import com.tcbj.tangsales.basedata.domain.person.assembler.StaffPostMapper;
import com.tcbj.tangsales.basedata.domain.person.assembler.StaffRegionMapper;
import com.tcbj.tangsales.basedata.domain.person.assembler.StaffShopMapper;
import com.tcbj.tangsales.basedata.domain.person.dto.PersonDTO;
import com.tcbj.tangsales.basedata.domain.person.entity.Person;
import java.util.ArrayList;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class PersonMapperImpl
implements PersonMapper {
    private final StaffDealerMapper staffDealerMapper = (StaffDealerMapper)Mappers.getMapper(StaffDealerMapper.class);
    private final StaffRegionMapper staffRegionMapper = (StaffRegionMapper)Mappers.getMapper(StaffRegionMapper.class);
    private final StaffPostMapper staffPostMapper = (StaffPostMapper)Mappers.getMapper(StaffPostMapper.class);
    private final RoleCMapper roleCMapper = (RoleCMapper)Mappers.getMapper(RoleCMapper.class);
    private final StaffShopMapper staffShopMapper = (StaffShopMapper)Mappers.getMapper(StaffShopMapper.class);

    @Override
    public Person toDo(PersonDTO dto) {
        if (dto == null) {
            return null;
        }
        Person person = new Person();
        person.setId(dto.getId());
        person.setFullname(dto.getFullname());
        person.setRoletype(dto.getRoletype());
        person.setPersontype(dto.getPersontype());
        person.setMf(dto.getMf());
        person.setIdnumber(dto.getIdnumber());
        person.setBirthdate(dto.getBirthdate());
        person.setEmpno(dto.getEmpno());
        person.setPrimaryphone(dto.getPrimaryphone());
        person.setPhonenumber(dto.getPhonenumber());
        person.setFamilyphone(dto.getFamilyphone());
        person.setEmail(dto.getEmail());
        person.setExtphone(dto.getExtphone());
        person.setQq(dto.getQq());
        person.setFaxphone(dto.getFaxphone());
        person.setAddress(dto.getAddress());
        person.setHiredate(dto.getHiredate());
        person.setDimissiondate(dto.getDimissiondate());
        person.setEducationalbg(dto.getEducationalbg());
        person.setStartdate(dto.getStartdate());
        person.setEnddate(dto.getEnddate());
        person.setOrgId(dto.getOrgId());
        person.setUserId(dto.getUserId());
        person.setPartnerId(dto.getPartnerId());
        person.setGroupid(dto.getGroupid());
        person.setTempEmpno(dto.getTempEmpno());
        person.setStaffDealers(this.staffDealerMapper.batchToDo(dto.getStaffDealers()));
        person.setStaffRegions(this.staffRegionMapper.batchToDo(dto.getStaffRegions()));
        person.setStaffPosts(this.staffPostMapper.batchToDo(dto.getStaffPosts()));
        person.setRoleCs(this.roleCMapper.batchToDo(dto.getRoleCs()));
        person.setStaffShops(this.staffShopMapper.batchToDo(dto.getStaffShops()));
        return person;
    }

    @Override
    public PersonDTO toDto(Person vo) {
        if (vo == null) {
            return null;
        }
        PersonDTO personDTO = new PersonDTO();
        personDTO.setId(vo.getId());
        personDTO.setFullname(vo.getFullname());
        personDTO.setRoletype(vo.getRoletype());
        personDTO.setPersontype(vo.getPersontype());
        personDTO.setMf(vo.getMf());
        personDTO.setIdnumber(vo.getIdnumber());
        personDTO.setBirthdate(vo.getBirthdate());
        personDTO.setEmpno(vo.getEmpno());
        personDTO.setPrimaryphone(vo.getPrimaryphone());
        personDTO.setPhonenumber(vo.getPhonenumber());
        personDTO.setFamilyphone(vo.getFamilyphone());
        personDTO.setEmail(vo.getEmail());
        personDTO.setExtphone(vo.getExtphone());
        personDTO.setQq(vo.getQq());
        personDTO.setFaxphone(vo.getFaxphone());
        personDTO.setAddress(vo.getAddress());
        personDTO.setHiredate(vo.getHiredate());
        personDTO.setDimissiondate(vo.getDimissiondate());
        personDTO.setEducationalbg(vo.getEducationalbg());
        personDTO.setStartdate(vo.getStartdate());
        personDTO.setEnddate(vo.getEnddate());
        personDTO.setOrgId(vo.getOrgId());
        personDTO.setUserId(vo.getUserId());
        personDTO.setPartnerId(vo.getPartnerId());
        personDTO.setGroupid(vo.getGroupid());
        personDTO.setTempEmpno(vo.getTempEmpno());
        personDTO.setStaffDealers(this.staffDealerMapper.batchToDto(vo.getStaffDealers()));
        personDTO.setStaffRegions(this.staffRegionMapper.batchToDto(vo.getStaffRegions()));
        personDTO.setStaffPosts(this.staffPostMapper.batchToDto(vo.getStaffPosts()));
        personDTO.setRoleCs(this.roleCMapper.batchToDto(vo.getRoleCs()));
        personDTO.setStaffShops(this.staffShopMapper.batchToDto(vo.getStaffShops()));
        return personDTO;
    }

    @Override
    public List<PersonDTO> batchToDto(List<Person> vos) {
        if (vos == null) {
            return null;
        }
        ArrayList<PersonDTO> list = new ArrayList<PersonDTO>(vos.size());
        for (Person person : vos) {
            list.add(this.toDto(person));
        }
        return list;
    }

    @Override
    public List<Person> batchToDo(List<PersonDTO> dtos) {
        if (dtos == null) {
            return null;
        }
        ArrayList<Person> list = new ArrayList<Person>(dtos.size());
        for (PersonDTO personDTO : dtos) {
            list.add(this.toDo(personDTO));
        }
        return list;
    }
}

